package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcZdGlService {
    /**
     * @param hashMap
     * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
     * @rerutn
     * @description 获取查封类型字典
     */
    List<HashMap> getBdcZdCflx(HashMap hashMap);

    /**
     * 获取所有申请字典数据
     *
     * @return
     */
    List<BdcZdSqlx> getBdcZdSqlxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有权利类型字典表
     **/
    List<BdcZdQllx> getBdcZdQllxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有验证字典项
     **/
    List<BdcZdCheck> getBdcZdCheckList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有必填字段字典表
     **/
    List<BdcZdTables> getBdcZdTableList();

    /**
     * lst 获取必填验证的table字典表的没有验证的字段
     *
     * @return
     */
    List<HashMap> getFields(final String tableId);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有房屋类型字典表
     **/
    List<BdcZdFwlx> getBdcZdFwlxList();


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有登记类型字典表
     **/
    List<BdcZdDjlx> getBdcZdDjlxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有定着物特征码字典表
     **/
    List<Map> getBdcZdDzwtzmList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有的权利性质字典表
     **/
    List<Map> getBdcZdQlxzList(Map<String, String> map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有的权利性质字典表
     **/
    List<Map> getBdcZdQlxz(HashMap map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所以的抵押方式字典表
     **/
    List<Map> getBdcZdDyfsList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有的宗地特征码字典表
     **/
    List<Map> getBdcZdZdtzmList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取所有的不动产类型字典表
     **/
    List<Map> getBdcZdBdclxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据djlx获取相应的bdc_zd_sqlx字典表
     **/
    List<BdcZdSqlx> getBdcZdSqlxByDjlx(String djlx);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取证件类型字典表
     **/
    List<BdcZdZjlx> getBdcZdZjlxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据wdid获取相应的申请类型代码
     **/
    String getSqlxDmByWdid(String wdid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过sqlxdm获取相应的wdid
     **/
    String getWdidBySqlxDm(String sqlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过dm获取bdc_zd_qllx数据
     **/
    BdcZdQllx getBdcZdQllxByDm(String dm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdc_zd_mjdw的名称找到相对应的代码
     **/
    String getBdcZdMjdwDmByMc(String mc);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过代码获取相应的名称
     **/
    String getBdcZdDjsyMcByDm(String dm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description
     **/
    List<HashMap> getBdcZdDjsyList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取登记子项代码
     **/
    List<BdcZdDjzx> getBdcZdDjzxList();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取bdc_zd_djsy表
     **/
    HashMap getBdcZdDjsyByDm(String dm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description
     **/
    BdcZdDjlx getBdcZdDjlxBySqlx(String sqlx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取不动产单元房屋类型
     **/
    List<HashMap> getBdcZdBdcdyFwlx();

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zx</a>
     * @description 获取登记子项代码
     **/
    BdcZdDjzx getBdcZdDjzxByDjzxdm(String djzxdm);

    //获取法院字典表
    List<BdcZdFy> getBdcZdFy();

    //获取性质字典表
    List<HashMap> getQlxzZdb(HashMap hashMap);

    /**
     * @param hashMap
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @rerutn BdcZdQllx
     * @description 获取权利类型字典
     */
    List<BdcZdQllx> getBdcZdQllx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @rerutn
     * @description 获取不动产字典权利设定方式的字段表
     */
    List<Map> getBdcZdQlsdfsList();

    /**
     * @param
     * @author <a href="mailto:wenyuanwu@gtmap.cn">wenyuanwu</a>
     * @rerutn
     * @description 获取不动产字典权利设定方式的字段表
     */
    List<Map> getBdcZdQlsdfs(HashMap map);

    /**
     * 获取共有方式字典表
     *
     * @return
     */
    List<Map> getZdGyfs();

    List<BdcZdQllx> getBdcZdQllxBySqlx(String sqlx);

    List<BdcZdFwyt> getBdcZdFwyt();

    List<HashMap> getQlrxzList();

    List<HashMap> getQlrlxList();

    /**
     * @param
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取bdclx与qllx字典表
     */
    List<Map<String, String>> listBdcBdclxQllxRel(Map<String, Object> paramMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取登记类型字典
     */
    List<HashMap> getBdcZdDjlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取抵押不动产类型类型字典
     */
    List<HashMap> getBdcZdDybdclx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据代码or名称获取共有方式
     */
    List<HashMap> getBdcZdGyfsByDm(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据代码获取共有方式
     */
    String getGyfsByDm(String dm);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 构筑物类型字典表
     */
    List<HashMap> getBdcZdGzwlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取权籍宗地宗海用途
     */
    List<HashMap> getBdcZdzhyt(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取权籍无居民海岛用途
     */
    List<HashMap> getBdcWjmhdyt(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取用海类型
     */
    List<HashMap> getBdcZdYhlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取用海类型B
     */
    List<HashMap> getBdcZdYhlxb(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 获取海域等别
     */
    List<HashMap> getBdcZdHydb(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据不动产类型获取djlx
     */
    List<Map> getDjlxByBdclx(String bdclxdm);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据djlx获取sqlx
     */
    List<Map> getSqlxByDjlx(String djlxdm);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 转换名称为代码
     */
    String parseNameToCode(String name, String dictionaryName);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 转换代码为名称
     */
    String parseCodeToName(String code, String dictionaryName);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 用海方式
     */
    List<HashMap> getBdcZdYhfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 水域滩涂类型
     */
    List<HashMap> getBdcZdSyttlx(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 养殖方式
     */
    List<HashMap> getBdcZdYzfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 承包方式
     */
    List<HashMap> getBdcZdCbjyqqdfs(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 项目性质
     */
    List<HashMap> getBdcZdXmxz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 房屋性质
     */
    List<HashMap> getDjsjZdFwxz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 房屋结构
     */
    List<HashMap> getDjsjZdFwjg(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 林种
     */
    List<HashMap> getBdcZdLz(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 林种
     */
    List<HashMap> getDjsjZdLdqy(HashMap hashMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 权籍s_zd_dldm
     */
    List<HashMap> getDjsjZdDldm(HashMap hashMap);

    /**
     *
     * @param sqlxdm
     * @return
     */
    public String getSqlxMcByDm(String sqlxdm);
    /**
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @param
     * @rerutn
     * @description 根据工作流定义ID获取不动产申请类型代码
     */
    String getBdcSqlxdmByWdid(final String wdid);

    /**
     * @author:<a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @data:2016/3/30
     * @param:HashMap
     * @return:List<BdcZdSqlx>
     * @description: 字典写了要可拓展的, 不要定死一个字段
     */
    List<BdcZdSqlx> getBdcSqlxByMap(HashMap hashMap);

    /**
     * zdd 获取登记类型申请类型关系表
     *
     * @return
     */
    List<Map> getDjlxSqlxRel();
}
