package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsQlrRel;

import java.util.List;

/**
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-23
 * @description 不动产登记证书权利人关系服务
 */
public interface BdcZsQlrRelService {

    /**
     * zx 删除证书和权利人证书关系表根据证书ID
     * @param zsid
     */
    void delZsQlrRelByZsid(final String zsid);
    /**
     * zdd 删除权利人证书关系表根据权利人ID
     *
     * @param qlrid
     */
    void delBdcZsQlrRelByQlrid(final String qlrid);
    /**
     * zdd 根据项目信息、证书信息、权利人信息生成权利人证书关系表
     * @param bdcXm 是否分别持证信息判读
     * @param bdcZsList
     * @param bdcQlrList
     * @return
     */
    public List<BdcZsQlrRel> creatBdcZsQlrRel(BdcXm bdcXm, List<BdcZs> bdcZsList, List<BdcQlr> bdcQlrList);

}
