package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.*;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcZsService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid查询所有的bdc_zs数据
     **/
    List<BdcZs> getBdcZsByProid(final String proid);


    /**
     * lst 批量获取证书
     *
     * @param wiid
     * @return
     */
    List<BdcZs> getPlZsByWiid(final String wiid);

    /**
     * zdd 根据权利人id 查找权利证书
     *
     * @param zsid
     * @return
     */
    BdcZs queryBdcZsByQlrid(final String zsid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcqzh查询所有的bdc_zs数据
     **/
    List<BdcZs> getBdcZsByBdcqzh(final String bdcqzh);

    /**
     * 获取核定日期
     *
     * @param map
     * @return
     */
    Map<String, Object> getHdrqByWiid(HashMap map);

    /**
     * 获取证书视图
     *
     * @param map
     * @return
     */
    List<HashMap> getViewBdcqzList(HashMap map);

    /**
     * @author
     * @description 通过zsid获取bdcdy数量
     */
    Integer getBdcdyCountByZsid(String zsid);

    /**
     * @Author:
     * @Description:获取权利其他状况
     * @Date
     */
    String getQlqtzk(String proid);

    /**
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 获取使用期限
     */
    HashMap<String, Object> getSyqx(HashMap<String, Object> map);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @Description:保存证书
     * @Date 16:29 2017/7/20
     */
    void saveZs(BdcZs bdcZs);

    /**
     * @author <a href="mailto:zhengqi@gtmap.cn">zhengqi</a>
     * @param bdcZsList
     * @description 验证不动产权证号是否已存在
     */
    String checkBdcqzh(List<BdcZs> bdcZsList);

    /**
     * @Author:
     * @Description:获取附记
     * @Date
     */
    String getFj(String proid);

    /**
     * @param zsid
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除证书
     */
    void deleteBdcZs(String zsid);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">juyulin</a>
     * @description 取出时全部不动产权证书证明信息
     */
    List<BdcZs> listBdcZsxx(Map map);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param map
     * @return
     * @description 获取不动产权证书证明信息
     */
    List<BdcZs> getBdcZsList(Map map);


    /**
     * @param bdcqzh
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据不动产权证号获取不动产单元号
     */
    List<String> getBdcdyhByBdcqzh(String bdcqzh);

    /**
     * @param bdcqzh
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @description 根据不动产权证号获取项目id
     */
    String getProidByBdcqzh(String bdcqzh);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @Description:获取不动产证书数量
     * @Date 9:41 2017/12/25
     */
    Integer getBdczsCount();

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @Description:根据wiid获取该流程所有证书证明号
     * @Date 9:42 2017/12/26
     */
    List<String> listPlZsZmhByWiid(@Param("wiid") String wiid);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @Description:根据proids获取所有证书证明号
     * @Date 9:42 2017/12/26
     */
    List<String> listPlZsZmhByProids(List<String> proids);

    /**
     * @Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @Description:获取当前项目所有证书证明号
     * @Date 9:42 2017/12/26
     */
    List<String> listPlZsZmhByProid(@Param("proid") String proid);

    /**
     * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
     * @param:bdcqzh
     * @Description:获取bdcxm
     * @Date 18:18 2018/1/3
     */
    BdcXm getBdcXmByBdcqzh(String bdcqzh);

    /**
     * @param bdcqzhList 不动产权证书集合
     * @return 项目
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @description 查询项目
     */
    List<BdcXm> getBdcXmByBdcqzh(List<String> bdcqzhList);


    /**
     * @Author:<a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param: qlrid
     * @Description: 根据qlrid获取证书
     * @Date 10:12 2018/3/18
     */
    List<BdcZs> getBdcZsByQlrid(final String qlrid);

    /**
     * zdd 根据项目ID删除不动产证书
     *
     * @param zsid
     */
    void delBdcZsByZsid(final String zsid);


    /**
     * zdd 根据项目ID查找证书（证明）
     *
     * @param proid
     * @return
     */
    List<BdcZs> queryBdcZsByProid(final String proid);

    /**
     * @param bdcXm
     * @param bdcQlrList
     * @return
     */
    List<BdcZs> creatBdcqz(BdcXm bdcXm, List<BdcQlr> bdcQlrList);

    /**
     * zx 根据项目ID删除不动产证书
     *
     * @param proid
     */
    void delBdcZsByProid(final String proid);

    /**
     * zdd 生成不动产权证书
     *
     * @param bdcXm
     * @param czr
     * @param bdcqzh 不动产权证号 如果为空则从新生成
     * @return
     */
    BdcDyZs creatBdcZs(BdcXm bdcXm, String czr, String bdcqzh);

    /**
     * sc 获取权利其他状况
     *
     * @param bdcZs
     * @return
     */
    BdcDyZs getZsQlqtzk(BdcXm bdcXm, BdcDyZs bdcZs);


    /**
     * zdd 创建不动产权证（证明 证书）
     *
     * @param bdcXm      项目信息
     * @param bdcQlrList 项目权利人信息
     * @return 已经生成的证书
     */
    List<BdcZs> creatBdcqz(BdcXm bdcXm, List<BdcQlr> bdcQlrList, String userId);

    /**
     * @param bdcXm
     * @param czr
     * @param bdcqzh
     * @param userId
     * @return
     */
    BdcDyZs creatBdcZs(BdcXm bdcXm, String czr, String bdcqzh, String userId);

    /**
     * zdd 获取最大流水号
     *
     * @param map
     * @return
     */
    Integer getMaxLsh(final Map map);

    /**
     * 根据不动产权证号获取bdc_xmzs_rel数据
     *
     * @param bdcqzh
     * @return
     */
    List<BdcXmzsRel> getBdcXmzsRelByBdcqzh(String bdcqzh);


    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description 退回删除缮证人、缮证日期
     */
    void backDelSzrByWiid(String wiid);

    /**
     * @param bdcZs
     * @return
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @description 更新证书表冗余字段
     */
    void updateBdcZsRedundantField(BdcZs bdcZs);

}
