package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsbh;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: sunchao
 * Date: 15-9-18
 * Time: 下午3:55
 *
 * @description 不动产登记证书编号（证书印制号）服务
 */
public interface BdcZsbhService {

    List<BdcZsbh> getBdcZsBhListByBhfw(Map map);

    String checkAndSaveZsh(List<BdcZsbh> bdcZsbhList, BdcZsbh bdcZsbh, String qsbh, String jsbh);

    /*
      *  根据起止箱号获取编号
      */
    List<BdcZsbh> getBdcZsBhListByQzBh(Map map);

    //根据箱号获取编号数量
    int getCountBdcZsBhByXh(String xh);

    /**
     * 用印号分配到乡镇
     *
     * @param hashMap
     * @return
     */
    String getZsbhByDwdm(HashMap hashMap);

    /**
     * 查询最小编号并且保存
     *
     * @param zslx
     * @param zsid
     * @return
     */
    String getZsBh(final String zslx, final String zsid);

    /**
     * 查询最小编号
     *
     * @param zslx
     * @return
     */
    String getZsbh(final String zslx);

    /**
     * 获取证书编号预警内容
     *
     * @param zslx
     * @return
     */
    Map getZsYjByZslx(final String zslx);

    /*
 * 验证证书编号
 */
    String checkZsbhNew(String proid, String zslx, String zsbh, String organName, String zsid, String syr);

    /**
     * 获取默认证书编号前六位
     *
     * @return
     */
    String getDefaultSixNumZsBh(String zslx);

    /**
     * 获取不动产权证编号
     *
     * @param bdcXm
     * @param bdcZs
     * @param zsIndex
     * @return
     */
    BdcZs creatBdcqzBh(BdcXm bdcXm, BdcZs bdcZs, int zsIndex);

    /**
     * zdd 获取不动产证号 年份
     *
     * @param bdcXtConfig
     * @return
     */
    String getBhYear(BdcXtConfig bdcXtConfig);

    /**
     * zdd 获取不动产证号 行政区简称
     *
     * @param bdcXtConfig
     * @return
     */
    String getXzqShortName(BdcXtConfig bdcXtConfig);
    /**
     * zdd 获取不动产证号简称
     *
     * @param bdcXtConfig
     * @return
     */
    String getProvinceShortName(BdcXtConfig bdcXtConfig);
    /**
     * zdd 获取不动产证号 流水号
     *
     * @param bdcXtConfig
     * @return
     */
    String getLsh(BdcXtConfig bdcXtConfig, String zsFont, int zsIndex,BdcXm bdcXm);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  修改证书编号使用情况为已打证
     */
    void changeZsbhSyqk(BdcXm bdcXm);


}
