package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcBdcdjb;
import cn.gtmap.estateplat.model.server.core.BdcBdcdy;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface BdcdyService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcdyh获取产权区主键
     **/
    List<String> getCqqidByBdcdy(String bdcdyh);

    /**
     * @param
     * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
     * @rerutn
     * @description 通过宗地宗海号和不动产类型获取不动产单元
     */
    List<BdcBdcdy> getBdcdyByZdzhh(final String zdzhh, final String bdclx);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过不动产单元号获取不动产单元信息
     **/
    BdcBdcdy getBdcdyByBdcdyh(String bdcdyh);

    /*
  * zwq
  * 通过房屋的不动产单元号寻找到宗地的不动产单元号
  * */
    String getZdBdcdyh(final String bdcdyh);

    /**
     * 根据proid 查询唯一不动产单元
     *
     * @param bdcdyid
     * @return
     */
    BdcBdcdy queryBdcdyById(final String bdcdyid);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 通过proid查询唯一不动产单元
     */
    BdcBdcdy queryBdcBdcdyByProid(final String proid);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 初始化登记簿
     */
    BdcBdcdy initBdcdy(String bdcdyh, String bdclx, String bdcdyFwlx, BdcBdcdjb bdcdjb);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 初始化地籍不动产单元
     */
    BdcBdcdy initDjBdcdy(String djId, String bdcdyh, String bdclx, String bdcdyFwlx);

    /**
     * @param bdcdyh
     * @param bdclx
     * @return map
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据不动产单元号和不动产类型获取地籍数据
     */
    Map<String, String> getDjsjBdcdy(String bdcdyh, String bdclx);

    /**
     * 匹配不动产单元和房产证
     *
     * @param map
     * @return
     */
    List<String> queryBdcdyhByDah(final Map map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 找出该流程所有不动产单元
     **/
    List<BdcBdcdy> listBdcBdcdy(final String wiid);
    /**
     * 根据qlr获取所有地籍数据id
     *
     * @param qlr
     * @param bdclx
     * @return
     */
    String[] getDjQlrIdsByQlr(final String qlr,final  String bdclx);

    /**
     * 根据地籍id获取权利人
     *
     * @param djid
     * @return
     */
    String getDjQlrByDjid(final String djid, String bdclxdm, final String zdtzm, String wfsqlxdm);

    /**
     * zdd 删除不动产单元
     *
     * @param bdcdyid
     */
    void delBdcdyById(final String bdcdyid);

    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 获取最大的不动产单元号
     */
    Integer getMaxBdcdyhLsh(Map map);

    /**
     * @author <a href="mailto:maxiaofeng@gtmap.cn">maxiaofeng</a>
     * @date 2021/3/19
     * @param
     * @return
     * @description  根据权利人获取地籍数据ids
     */
    String[] getDjidsByQlr(final String bdclx, final String qlrmc, final String qlrzjh);
}
