package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.model.server.core.*;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface DjsjService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取土地地籍数据
     **/
    List<DjsjBdcdy> getDjsjBdcdyTdList(HashMap hashMap);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过bdcdyh获取djsj_fw_ychs数据
     **/
    List<DjsjFwYcHs> getDjsjFwYcHsListByBdcdyh(String bdcdyh);

    /**
     * @param map
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 根据宗地变更后的地籍号查询变更前的原地籍号
     */
    List<String> getYdjhByDjh(HashMap map);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 根据djid获取相应的djsj_fwxx
     **/
    List<DjsjBdcdy> getDjsjBdcdyTdFwByDjid(String djid);

    /**
     * 通过djh读取宗地信息
     *
     * @param djh
     * @return
     */
    List<DjsjZdxx> getDjsjZdxxForDjh(final String djh);

    /**
     * 通过id读取林权信息
     *
     * @param id
     * @return
     */
    DjsjLqxx getDjsjLqxx(final String id);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djid获取承包宗地数据
     **/
    DjsjCbzdDcb getDjsjCbzdDcbByDjid(final String djid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djh获取农用地数据
     **/
    List<DjsjNydDcb> getDjsjNydDcbByDjh(final String djh);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过djh获取权属宗地数据
     **/
    List<DjsjQszdDcb> getDjsjQszdDcb(final String djh);

    /**
     * 通过id读取宗地信息 由于关联权利人表  可能是多个
     *
     * @param id
     * @return
     */
    List<DjsjZdxx> getDjsjZdxx(final String id);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过id获取农用地数据
     **/
    List<DjsjZdxx> getDjsjNydxx(final String id);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid查询相关房屋的房屋类型
     **/
    String getFwlxByProid(final String proid);

    /**
     * @param djId   权籍ID
     * @param bdcdyh 不动产单元号
     * @param bdclx  不动产类型
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description
     */
    InitVoFromParm getDjxx(String djId, String bdcdyh, String bdclx, String bdcdyFwlx);

    /**
     * 获取房屋类型
     *
     * @param djid
     * @return
     */
    DjsjFwxx getDjsjFwxx(final String djid, final String bdcdyFwlx);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 获取地籍数据不动产单元
     */
    List<Map<String, String>> getDjBdcdyListByPage(Map<String, Object> paramMap);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据djh获取权籍林权信息
     */
    List<DjsjLqxx> getDjsjLqxxByDjh(@Param("djh") String djh);

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 根据djh获取权籍土地承包经营权信息
     */
    List<DjsjCbzdDcb> getDjsjCbzdDcbByDjh(@Param("djh") String djh);


    /**
     * @param
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @rerutn
     * @description 根据bdcdyh获取房屋户室信息
     */
    List<DjsjFwHs> getDjsjFwHsByBdcdyh(final String bdcdyh);

    /**
     * 获取权利人
     *
     * @param map
     * @return
     */
    List<Map> getDjQlrList(Map map);

    /**
     * @param djh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn Integer
     * @description 根据地籍号查询不动产数量
     */
    public Integer queryBdcdyCountByDjh(final String djh);
    /**
     * @param bdcdyh
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn List<String>
     * @description 根据不动产单元号获取房屋类型
     */
    List<String> getBdcfwlxByBdcdyh(String bdcdyh);

}
