package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.Dwxx;

import java.util.List;

/**
 * @version 1.0, 2017/6/26.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface DwdmService {

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过userid获取相对应的单位代码
     **/
    public String getDwdmByUserid(String userid);

    /**
     * 根据行政区代码，和行政级别获取单位信息
     *
     * @param xzqdm
     * @param level
     * @return
     */
    List<Dwxx> getDwxxList(final String xzqdm, final int level);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取单位代码字典项
     **/
    List<Dwxx> getDwxxList();

    /**
     * 根据行政区代码获取单位信息
     *
     * @param xzqdm
     * @return
     */
    Dwxx getDwxxByDwdm(final String xzqdm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过单位代码和level获取单位信息, 作为证书编号传入前台的值
     **/
    List<Dwxx> getDwxxToZsbh(String userDwdm, int level);

}
