package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdFwQl;
import cn.gtmap.estateplat.model.server.core.GdFwsyq;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface GdFwService {

    /**
     * @param gdproid
     * @author <a href="mailto:sunchao@gtmap.cn">sunchao</a>
     * @rerutn
     * @description 根据GdProid获取CQQID
     */
    List<String> getCqqidByGdProid(String gdproid);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gdproid获取gd_fw
     **/
    List<GdFw> getGdFwByGdProid(String gdproid);

    /**
     * 根据项目id获取过渡房屋权利ids
     *
     * @param proid
     * @return
     */
    List<String> getGdFwQlidsByProid(final String proid);


    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gdproid获取gd_fwsyq
     **/
    List<GdFwsyq> getGdFwsyqListByGdproid(String gdproid, String iszx);

    /**
     * zx 根据过渡不动产id或者权利id获取权利ids
     *
     * @param gdBdcid
     * @return
     */
    List<GdBdcQlRel> getGdBdcQlRelByBdcidOrQlid(String gdBdcid, String qlid);

    /**
     * zdd 根据map参数条件查询过度信息抵押信息
     *
     * @param map
     * @return
     */
    List<GdFwsyq> andEqualQueryGdFwsyq(final Map<String, Object> map);

    /**
     * zx权利id获取房屋所有权
     * @param qlid
     * @return
     */
    GdFwsyq getGdFwsyqByQlid(String qlid);

    /**
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @param fwid 房屋ID
     * @return
     * @description 根据过渡房屋ID获取房屋所有权
     */
    List<GdFwsyq> queryFwsyqByFwid(String fwid);

    /**
     * 根据权利id查询过渡房屋
     *
     * @param qlid
     * @return
     */
    List<GdFw> getGdFwByQlid(final String qlid);

    /**
     * 根据不动产单元号查询过渡房屋
     *
     * @param bdcdyh
     * @return
     */
    List<GdFw> getGdFwBybdcdyh(final String bdcdyh);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:gdid
    *@Description:通过gdid获取相关过渡房产权的qlid
    *@Date 14:22 2017/12/21
    */
    List<String> getGdFwsyqQlidListByGdid(String gdid);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:fwid
    *@Description:根据fwid获取gdfw
    *@Date 15:28 2017/12/21
    */
    GdFw getGdFwByFwid(String fwid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdFwsyq
     * @return
     * @description 更新过渡房屋所有权冗余字段
     */
    void updateGdFwsyqRedundantField(GdFwsyq gdFwsyq);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdFwQl
     * @return
     * @description 更新过渡房屋权利冗余字段
     */
    void updateGdFwQlRedundantField(GdFwQl gdFwQl);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param fczh
     * @return
     * @description 根据房屋所有权获取房屋所有权列表
     */
    List<GdFwsyq> getGdFwsyqListByFczh(String fczh);



    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param qlid
     * @return
     * @description
     */
    GdFwsyq queryGdFwsyqByQlid(String qlid);
}
