package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.GdQlr;

import java.util.HashMap;
import java.util.List;

/**
 * @Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
 * @Date 14:41 2017/12/21
 */
public interface GdQlrService {

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:qlid
    *@Description:获取过渡权利人列表
    *@Date 14:41 2017/12/21
    */
    List<GdQlr> getGdQlrListByqlidAndQlrlx(String gdQlid, String qlrlx);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:gdqlrlist
    *@Description:
    *@Date 14:56 2017/12/21
    */
    String combinationQlr(final List<GdQlr> gdQlrList);

    /**
     * @author <a herf="mailto:xinghuajian@gtmap.cn">xinghuajian</a>
     * @param proid
     * @description 根据proid获得qlr和ywr
     */
    HashMap<String,String> combinationQlrAndYwrByProid(final String proid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param cqzh
     * @return
     * @description 根据产权证号获取过渡权利人
     */
    List<GdQlr> getGdQlrListByCqzh(String cqzh);
}
