package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.GdTd;
import cn.gtmap.estateplat.model.server.core.GdTdQl;
import cn.gtmap.estateplat.model.server.core.GdTdsyq;

import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface GdTdService {
    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过房屋qlid获取土地qlid
     **/
    String getTdQlidByFwQlid(String qlid);

    /**
     * @param djh
     * @author <a href="mailto:sunchao@gtmap.cn">sc</a>
     * @rerutn
     * @description 根据土地地籍号获取过渡土地权利id
     */
    List<String> getGdTdQlidByDjh(final String djh);

    /**
     * 获取土地ID获取土地所有权
     *
     * @param tdid
     * @return
     */
    List<GdTdsyq> queryTdsyqByTdid(final String tdid);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过gdproid查询gdTd
     **/
    List<GdTd> getGdTdByProid(String proid);

    /**
     * 根据地籍号获取土地数据
     *
     * @param djh
     * @return
     */
    GdTd getGdTdByDjh(final String djh);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:tdid
    *@Description:
    *@Date 17:03 2017/12/21
    */
    GdTd getGdTdByTdid(String tdid);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdTdsyq
     * @return
     * @description 更新过渡土地所有权冗余字段
     */
    void updateGdTdsyqRedundantField(GdTdsyq gdTdsyq);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param gdTdQl
     * @return
     * @description 更新过渡土地权利冗余字段
     */
    void updateGdTdQlRedundantField(GdTdQl gdTdQl);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param tdzh
     * @return
     * @description 根据土地证号获取土地所有权列表
     */
    List<GdTdsyq> getGdTdsyqListByTdzh(String tdzh);


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param qlid
     * @return
     * @description 根据qlid获取过渡土地所有权
     */
    GdTdsyq queryGdTdsyqByQlid(String qlid);
}
