package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.GdXm;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface GdXmService {
    /**
     * zdd 根据过渡项目ID找到过渡不动产ID
     *
     * @param gdproid
     * @return
     */
    List<String> getGdBdcidByProid(final String gdproid);

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据qlid获取所有过渡证号
     *@Date 9:42 2017/12/26
     */
    List<String> listPlCqzhByQlid(final String qlid);

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据fwid获取所有该房屋上的权利证号
     *@Date 9:42 2017/12/26
     */
    List<String> listCqzhByFwid(final String fwid);

    /**
     *@Author:<a href="mailto:juyulin@gtmap.cn">juyulin</a>
     *@Description:根据tdid获取所有该土地上的证号
     *@Date 9:42 2017/12/26
     */
    List<String> listCqzhByTdid(final String tdid);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:cqzh
    *@Description:过渡proid
    *@Date 19:08 2018/1/3
    */
    List<String> getGdproidByCqzh(String cqzh);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:gdproid
    *@Description:获取权属状态
    *@Date 13:50 2018/1/4
    */
    String getGdQsztByGdProid(String gdproid);
    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:gdproid
    *@Description:cqzh
    *@Date 9:38 2018/1/5
    */
    String getCqzhByGdproid(String proid);

    /**
    *@Author:<a href="mailto:huangzijian@gtmap.cn">huangzijian</a>
    *@param:proid
    *@Description:组织共享需要的list对象
    *@Date 10:21 2018/1/5
    */
    Map getGxObjectByGdproid(String proid);


    List<GdXm> getGdXmListByGdProid(String gdproid);
}
