package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.model.server.core.QllxParent;
import cn.gtmap.estateplat.model.server.core.QllxVo;

import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface QllxParentService {

    /**
     * zdd 根据map参数  获取对应的状态正常的qllx
     *
     * @param qllxVo 实例化的qllx
     * @param map
     * @return QllxParent
     */
    List<QllxParent> queryZtzcQllxVo(QllxVo qllxVo, Map<String, Object> map);

    /**
     * sc 自定义查询权利
     *
     * @param qllxVo 实例化的qllx
     * @param map
     * @return QllxParent
     */
    List<QllxParent> queryQllxVo(QllxVo qllxVo, Map<String, Object> map);

    /**
     * sc 根据不动产单元号  获取对应的cf状态的qllx
     *
     * @param qllxVo 实例化的qllx
     * @param bdcdyh 不动产单元号
     * @return QllxParent
     */
    List<QllxParent> queryLogcfQllxVo(QllxVo qllxVo, String bdcdyh, String xmzt, String isycf);

    /**
     * zdd  根据map参数  获取对应的状态正常的qllx
     *
     * @param qllxVo
     * @param map
     * @return
     */
    List<Map> queryZtzcQllxMap(QllxVo qllxVo, Map<String, Object> map);
}
