package cn.gtmap.estateplat.config.core.service;

import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.QllxVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
public interface QllxService {
    /**
     * zdd 确定不动产登记所产生的权利类型
     *
     * @param bdcXm
     * @return 权利类型VO
     */
    QllxVo makeSureQllx(final BdcXm bdcXm);

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 获取权利表名
     **/
    String getTableName(QllxVo vo);

    /**
     * lst 获取QllxVo的所有实现类并根据proid查询
     *
     * @param proid
     * @return
     */
    QllxVo getQllxVoByProid(String proid);


    /**
     * 获取权利信息列表
     *
     * @param map
     * @return
     */
    List<Map> getQllxListByPage(HashMap map);

    /**
     * zdd 根据权利类型确定证书类型
     *
     * @param qllxVo
     * @return BDCQZS_BH_FONT or BDCQZM_BH_FONT
     */
    String makeSureBdcqzlx(QllxVo qllxVo);

    /**
     * zdd 根据权利类型代码以及项目ID  找到权利类型实体类
     * zwq 按bdclx来查询
     * //     * @param qllx  权利类型代码
     * //     * @param proid 项目ID
     * //     * @return 权利类型实体类
     */
    QllxVo queryQllxVo(BdcXm bdcXm);

    /**
     * zdd 根据实体qllxVo 以及项目ID查找
     *
     * @param qllxVo
     * @param proid
     * @return
     */
    QllxVo queryQllxVo(QllxVo qllxVo, String proid);

    /**
     * @param qllx
     * @param bdcdyh
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据不动产单元号查询权利
     */
    QllxVo queryQllxVoByBdcdyh(String bdcdyh, String qllx);

    /**
     * @param qllx
     * @param bdcdyid
     * @return
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据不动产单元id查询权利
     */
    QllxVo queryQllxVoByBdcdyid(String bdcdyid, String qllx);

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建权力表
     */
    QllxVo newQllxVo(BdcXm bdcXm, String bdcdyid, InitVoFromParm initVoFromParm);

    /**
     * @param bdcdyh    不动产单元号
     * @param bdclx     不动产类型
     * @param djId      地籍ID
     * @param bdcdyFwlx 不动产单元房屋类型
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 根据不动产单元号创建产权
     */
    QllxVo initPropertyRight(String bdcdyh, String bdclx, String djId, String bdcdyFwlx);

    /**
     * zdd 办结修改当前权利状态为1
     *
     * @param bdcXm
     */
    void endQllxZt(BdcXm bdcXm);

    /**
     * zdd  改变项目对应权利类型的权属状态
     *
     * @param bdcxm
     * @param qszt
     */
    void changeQllxZt(BdcXm bdcxm, Integer qszt, Boolean ignoreHr);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新登簿情况（人和时间）
     */
    QllxVo updateDbr(QllxVo qllxVo, String userId);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description 更新注销登簿情况
     */
    QllxVo updateZxDbr(QllxVo yqllxVo, String userId);


    /**
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @description   注销登记流程删除后 数据置空
     */
    void updateZxQllx(QllxVo qllxVo);


    /**
     * @param
     * @return
     * @author <a href="mailto:liaoxiang@gtmap.cn">liaoxiang</a>
     * @description  获取虚拟不动产单元号权利类型
     */
    String getQllxByXnbdcdyh(String bdcdyh);
}
