package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcCfMapper;
import cn.gtmap.estateplat.config.core.service.BdcCfService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcCfServiceImpl implements BdcCfService {

    @Autowired
    BdcCfMapper bdcCfMapper;
    @Autowired
    EntityMapper entityMapper;

    @Override
    public BdcCf getXsBdcCfByProid(String proid) {
        BdcCf bdcCf = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS.toString());
            List<BdcCf> bdcCfList = bdcCfMapper.getBdcCfList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcCfList))
                bdcCf = bdcCfList.get(0);
        }
        return bdcCf;
    }

    @Override
    public BdcCf getBdcCfByProid(String proid) {
        BdcCf bdcCf = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            List<BdcCf> bdcCfList = bdcCfMapper.getBdcCfList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcCfList))
                bdcCf = bdcCfList.get(0);
        }
        return bdcCf;
    }

    @Override
    public List<BdcCf> getXsBdcCfListByBdcdyid(String bdcdyid) {
        List<BdcCf> bdcCfList = null;
        if (StringUtils.isNotBlank(bdcdyid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcdyid", bdcdyid);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS.toString());
            bdcCfList = bdcCfMapper.getBdcCfList(hashMap);
        }
        return bdcCfList;
    }

    /**
     * 根据主键删除查封.
     *
     * @param ids 主键，多个主键以逗号隔开
     */
    public void deleteBdcCfByPrimaryKey(final String ids) {
        if (StringUtils.isBlank(ids))
            return;
        /**
         * 根据主键循环删除数据库记录
         */
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            if (StringUtils.isNotBlank(id[i])) entityMapper.deleteByPrimaryKey(BdcCf.class, id[i]);
        }
    }

    @Override
    public List<BdcCf> getBdcCfListByProid(String proid) {
        List<BdcCf> bdcCfList = null;
        if(StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcCf.class);
            example.createCriteria().andEqualTo("proid", proid);
            bdcCfList = entityMapper.selectByExample(example);
        }
        return bdcCfList;
    }

    @Override
    @Transactional
    public void updateBdcCfRedundantField(BdcCf bdcCf) {
        if(bdcCf != null&&StringUtils.isNotBlank(bdcCf.getQlid())) {
            bdcCfMapper.updateBdcCfRedundantField(bdcCf);
        }
    }
}
