package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcComplexFgHbHzService;
import cn.gtmap.estateplat.config.core.service.DjsjService;
import cn.gtmap.estateplat.config.core.service.QllxParentService;
import cn.gtmap.estateplat.model.server.core.BdcCf;
import cn.gtmap.estateplat.model.server.core.QllxParent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/30.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcComplexFgHbHzServiceImpl implements BdcComplexFgHbHzService {
    @Autowired
    QllxParentService qllxParentService;
    @Autowired
    DjsjService djsjService;

    public List<QllxParent> getYzdCf(String bdcdyh) {
        List<QllxParent> list = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            String zddDjh = StringUtils.substring(bdcdyh, 0, 19);
            HashMap hashMap = new HashMap();
            hashMap.put("djh", zddDjh);
            List<String> yZdDjhList = djsjService.getYdjhByDjh(hashMap);
            if (CollectionUtils.isNotEmpty(yZdDjhList)) {
                String yZdBdcdyh = "";
                for (String yZdDjh : yZdDjhList) {
                    yZdBdcdyh = yZdDjh + "W00000000";
                    list = qllxParentService.queryLogcfQllxVo(new BdcCf(), yZdBdcdyh, "", "false");
                    if (CollectionUtils.isNotEmpty(list))
                        break;
                }
            }
        }
        return list;
    }
}
