package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcdjbMapper;
import cn.gtmap.estateplat.config.core.service.BdcDjbService;
import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.*;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/9/4
 * @description
 */
@Service
public class BdcDjbServiceImpl implements BdcDjbService {

    @Autowired
    private BdcdjbMapper bdcdjbMapper;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private EntityMapper entityMapper;

    @Override
    @Transactional(readOnly = true)
    public BdcBdcdjb selectBdcdjb(final String zdzhh) {
        BdcBdcdjb bdcBdcdjb = null;
        if (StringUtils.isNotBlank(zdzhh)) {
            Map<String, Object> paramMap = Maps.newHashMap();
            paramMap.put("zdzhh", zdzhh);
            List<BdcBdcdjb> bdcBdcdjbList = bdcdjbMapper.selectBdcdjb(paramMap);
            if (CollectionUtils.isNotEmpty(bdcBdcdjbList)) {
                bdcBdcdjb = bdcBdcdjbList.get(0);
            }
        }
        return bdcBdcdjb;
    }

    @Override
    public BdcBdcdjb initBdcdjb(InitVoFromParm initVoFromParm, String djh) {
        BdcBdcdjb bdcBdcdjb = null;
        //zdd 如果宗地宗海号为空  则不生成
        if (StringUtils.isNotBlank(djh)) {
            bdcBdcdjb = new BdcBdcdjb();
            bdcBdcdjb.setDjbid(UUIDGenerator.generate18());
            bdcBdcdjb.setZdzhh(djh);
            if (SessionUtil.getCurrentUser() != null) {
                bdcBdcdjb.setDbr(SessionUtil.getCurrentUser().getUsername());
            }
            bdcBdcdjb.setDjsj(new Date());
            getBdcdjbFromQsdcb(initVoFromParm.getDjsjQszdDcb(), bdcBdcdjb);
            getBdcdjbFromNydZdxx(initVoFromParm.getDjsjNydDcbList(), bdcBdcdjb);
            getBdcdjbFromZdxx(initVoFromParm.getDjsjZdxx(), bdcBdcdjb);
            getBdcdjbFromLqxx(initVoFromParm.getDjsjLqxx(), bdcBdcdjb);
            getBdcdjbFromZhxx(initVoFromParm.getDjsjZhxx(), bdcBdcdjb);
        }
        return bdcBdcdjb;
    }

    @Override
    public void getBdcdjbFromQsdcb(DjsjQszdDcb djsjQszdDcb, BdcBdcdjb bdcBdcdjb) {
        if (djsjQszdDcb != null) {
            if (StringUtils.isNotBlank(djsjQszdDcb.getTdzl())) {
                bdcBdcdjb.setZl(djsjQszdDcb.getTdzl());
            }
            if (StringUtils.isNotBlank(djsjQszdDcb.getZdsz())) {
                bdcBdcdjb.setWzsm(djsjQszdDcb.getZdsz());
            }
        }
    }

    @Override
    public void getBdcdjbFromNydZdxx(List<DjsjNydDcb> djsjNydDcbList, BdcBdcdjb bdcBdcdjb) {
        if (CollectionUtils.isNotEmpty(djsjNydDcbList)) {
            DjsjNydDcb djsjNydDcb = djsjNydDcbList.get(0);
            if (StringUtils.isNotBlank(djsjNydDcb.getZdsz())) {
                bdcBdcdjb.setWzsm(djsjNydDcb.getZdsz());
            }
            if (StringUtils.isNotBlank(djsjNydDcb.getTdzl())) {
                bdcBdcdjb.setZl(djsjNydDcb.getTdzl());
            }
        }
    }

    @Override
    public void getBdcdjbFromZdxx(DjsjZdxx djsjZdxx, BdcBdcdjb bdcBdcdjb) {
        if (djsjZdxx != null) {
            if (StringUtils.isNotBlank(djsjZdxx.getZdsz())) {
                bdcBdcdjb.setWzsm(djsjZdxx.getZdsz());
            }
            if (StringUtils.isNotBlank(djsjZdxx.getTdzl())) {
                bdcBdcdjb.setZl(djsjZdxx.getTdzl());
            }
        }
    }

    @Override
    public void getBdcdjbFromLqxx(DjsjLqxx djsjLqxx, BdcBdcdjb bdcBdcdjb) {
        if (djsjLqxx != null) {
            if (StringUtils.isNotBlank(djsjLqxx.getZl())) {
                bdcBdcdjb.setZl(djsjLqxx.getZl());
            }
        }
    }

    @Override
    public void getBdcdjbFromZhxx(DjsjZhxx djsjZhxx, BdcBdcdjb bdcBdcdjb) {
        if (djsjZhxx != null) {
            if (StringUtils.isNotBlank(djsjZhxx.getYhwzsm())) {
                bdcBdcdjb.setWzsm(djsjZhxx.getYhwzsm());
            }
            if (StringUtils.isNotBlank(djsjZhxx.getHdwz())) {
                bdcBdcdjb.setZl(djsjZhxx.getHdwz());
            }
        }
    }


    @Override
    @Transactional
    public void updateDjb(final String proid, final String userName, final QllxVo qllxVo) {
        if (StringUtils.isBlank(proid)) {
            return;
        }
        BdcBdcdy bdcdy = bdcdyService.queryBdcBdcdyByProid(proid);
        if (bdcdy != null) {
            BdcBdcdjb bdcBdcdjb = selectBdcdjb(StringUtils.substring(bdcdy.getBdcdyh(), 0, 19));
            if (bdcBdcdjb != null) {
                bdcBdcdjb.setDbr(userName);
                bdcBdcdjb.setDjsj(new Date());
                bdcBdcdjb.setFj(qllxVo.getFj());
                entityMapper.saveOrUpdate(bdcBdcdjb, bdcBdcdjb.getDjbid());
            }
        }
    }

}
