package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcDyaqMapper;
import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.service.BdcDyaqService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcDyaq;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcDyaqServiceImpl implements BdcDyaqService {

    @Autowired
    BdcZdGlMapper bdcZdGlMapper;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private BdcDyaqMapper bdcDyaqMapper;

    @Override
    public List<BdcDyaq> getBdcDyaqListByProid(String proid, String qszt) {
        List<BdcDyaq> bdcDyaqList = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcDyaq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("proid", proid);
            if (StringUtils.isNotBlank(qszt))
                criteria.andEqualTo("qszt", qszt);
            bdcDyaqList = entityMapper.selectByExample(example);
        }
        return bdcDyaqList;
    }

    @Override
    public List<BdcDyaq> getBdcDyaqListByProidAndNotQszt(String proid, String notQszt) {
        List<BdcDyaq> bdcDyaqList = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcDyaq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("proid", proid);
            if (StringUtils.isNotBlank(notQszt))
                criteria.andNotEqualTo("qszt", notQszt);
            bdcDyaqList = entityMapper.selectByExample(example);
        }
        return bdcDyaqList;
    }

    @Override
    public List<BdcDyaq> getDyByBdcdyid(String bdcdyid) {
        Example example = new Example(BdcDyaq.class);
        example.createCriteria().andEqualTo("bdcdyid", bdcdyid).andNotEqualTo("qszt", 2);
        List<BdcDyaq> bdcDyaqList = entityMapper.selectByExample(example);
        return bdcDyaqList;
    }

    @Override
    @Transactional
    public void updateBdcDyaqRedundantField(BdcDyaq bdcDyaq) {
        if(bdcDyaq != null&&StringUtils.isNotBlank(bdcDyaq.getQlid())) {
            bdcDyaqMapper.updateBdcDyaqRedundantField(bdcDyaq);
        }
    }

}

