package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcFdcqDzMapper;
import cn.gtmap.estateplat.config.core.service.BdcFdcqDzService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcFdcqDz;
import cn.gtmap.estateplat.model.server.core.BdcFwfzxx;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @version 1.0, 2017/6/30.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcFdcqDzServiceImpl implements BdcFdcqDzService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private BdcFdcqDzMapper bdcFdcqDzMapper;
    @Autowired
    private BdcZsService bdcZsService;

    @Override
    public BdcFdcqDz getBdcFdcqDzByProid(String proid) {
        BdcFdcqDz bdcFdcqDz = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcFdcqDz.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcFdcqDz> bdcFdcqDzList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcFdcqDzList))
                bdcFdcqDz = bdcFdcqDzList.get(0);
        }
        return bdcFdcqDz;
    }

    @Override
    public void saveBdcFdcqDz(BdcFdcqDz bdcFdcqDz) {
        BdcFdcqDz gyqkBdcFdcqDz = entityMapper.selectByPrimaryKey(BdcFdcqDz.class, bdcFdcqDz.getQlid());
        if (gyqkBdcFdcqDz != null) {
            bdcFdcqDz.setGyqk(gyqkBdcFdcqDz.getGyqk());
        }
        entityMapper.saveOrUpdate(bdcFdcqDz, bdcFdcqDz.getQlid());
        if (bdcFdcqDz.getTdsyksqx() == null && bdcFdcqDz.getTdsyjsqx() == null)
            saveFdcqDzTdsyqx(bdcFdcqDz);
    }

    //保存房地产权中的土地使用期限为null
    void saveFdcqDzTdsyqx(BdcFdcqDz bdcFdcqDz) {
        bdcFdcqDzMapper.saveFdcqDzTdsyqx(bdcFdcqDz);
    }

    @Override
    public void saveBdcFwfzxx(BdcFwfzxx bdcFwfzxx) {
        entityMapper.saveOrUpdate(bdcFwfzxx, bdcFwfzxx.getFzid());
    }

    @Override
    public List<BdcFwfzxx> getBdcFwfzxxByFzid(String fzid) {
        List<BdcFwfzxx> bdcFwfzxxList = new ArrayList<BdcFwfzxx>();
        Example example = new Example(BdcFwfzxx.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("fzid", fzid);
        bdcFwfzxxList = entityMapper.selectByExample(BdcFwfzxx.class, example);
        return bdcFwfzxxList;
    }

    @Override
    public String getBdcFdcqDzFj(String qlid) {
        String fj = "";
        if (StringUtils.isNotBlank(qlid)) {
            Example example = new Example(BdcFdcqDz.class);
            example.createCriteria().andEqualTo("qlid", qlid);
            List<BdcFdcqDz> bdcFdcqDzList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcFdcqDzList)) {
                BdcFdcqDz bdcFdcqDz = bdcFdcqDzList.get(0);
                String dzXx = "";
                dzXx = bdcZsService.getFj(bdcFdcqDz.getProid());
                if (StringUtils.isNotBlank(dzXx)) {
                    if (StringUtils.isNotBlank(fj)) {
                        fj = fj + "\n" + dzXx;
                    } else {
                        fj = dzXx;
                    }
                }
                bdcFdcqDz.setFj(fj);
                saveBdcFdcqDz(bdcFdcqDz);
            }
        }
        return fj;
    }

    @Override
    public List<BdcFdcqDz> getBdcFdcqDzByBdcdyid(String bdcdyid) {
        return bdcFdcqDzMapper.getBdcFdcqDzByBdcdyid(bdcdyid);
    }

    @Override
    public List<BdcFwfzxx> getBdcFwfzxxByQlid(String qlid) {
        List<BdcFwfzxx> bdcFwfzxxList = new ArrayList<BdcFwfzxx>();
        Example example = new Example(BdcFwfzxx.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("qlid", qlid);
        bdcFwfzxxList = entityMapper.selectByExample(BdcFwfzxx.class, example);
        return bdcFwfzxxList;
    }

    @Override
    @Transactional
    public void updateBdcfdcqDzRedundantField(BdcFdcqDz bdcFdcqDz) {
        if(bdcFdcqDz != null&&StringUtils.isNotBlank(bdcFdcqDz.getQlid())) {
            bdcFdcqDzMapper.updateBdcfdcqDzRedundantField(bdcFdcqDz);
        }
    }
}
