package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcFdcqDzMapper;
import cn.gtmap.estateplat.config.core.mapper.config.BdcFdcqMapper;
import cn.gtmap.estateplat.config.core.service.BdcFdcqService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcFdcq;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcFdcqServiceImpl implements BdcFdcqService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcFdcqDzMapper bdcFdcqDzMapper;
    @Autowired
    BdcFdcqMapper bdcFdcqMapper;

    @Override
    public List<BdcFdcq> getBdcFdcqListByProid(String proid) {
        List<BdcFdcq> bdcFdcqList = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcFdcq.class);
            example.createCriteria().andEqualTo("proid", proid);
            bdcFdcqList = entityMapper.selectByExample(example);
        }
        return bdcFdcqList;
    }

    @Override
    public List<HashMap> getFdcqGyfsByProid(String proid) {
        return bdcFdcqDzMapper.getFdcqGyfsByProid(proid);
    }

    @Override
    public List<BdcFdcq> getBdcFdcqListByBdcdyid(String bdcdyid) {
        if (StringUtils.isNotBlank(bdcdyid)) {
            return bdcFdcqMapper.getFdcqByBdcdyid(bdcdyid);
        }
        return new ArrayList();
    }

    @Override
    @Transactional
    public void updateBdcfdcqRedundantField(BdcFdcq bdcFdcq) {
        if(bdcFdcq != null&&StringUtils.isNotBlank(bdcFdcq.getQlid())) {
            bdcFdcqMapper.updateBdcfdcqRedundantField(bdcFdcq);
        }
    }
}
