package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcFyMapper;
import cn.gtmap.estateplat.config.core.service.BdcFyService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcZdFy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2017/8/30.
 */
@Service
public class BdcFyServiceImpl implements BdcFyService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcFyMapper bdcFyMapper;

    /**
     * 根据主键插入或更新法院配置.
     *
     * @param bdcZdFy 法院配置信息
     */
    @Override
    @Transactional
    public void insertOrUpdateByPrimaryKey(final BdcZdFy bdcZdFy) {
        if (bdcZdFy == null) return;
        BdcZdFy bdcZdFy1 = entityMapper.selectByPrimaryKey(BdcZdFy.class, bdcZdFy.getDm());
        if (bdcZdFy1 != null) {
            entityMapper.updateByPrimaryKey(bdcZdFy);
        } else {
            entityMapper.insertSelective(bdcZdFy);
        }
    }

    /**
     * 根据主键删除法院配置.
     *
     * @param ids 主键，多个主键以逗号隔开
     * @return
     * @author liubin
     * @description 根据主键删除法院配置.
     */
    @Override
    @Transactional
    public void deleteFyByPrimaryKey(final String ids) {
        if (StringUtils.isBlank(ids))
            return;
        /**
         * 根据主键循环删除数据库记录
         */
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            if (StringUtils.isNotBlank(id[i])) entityMapper.deleteByPrimaryKey(BdcZdFy.class, id[i]);
        }
    }

    @Override
    public List<HashMap> getBdcFyMapList() {
        return bdcFyMapper.getBdcFyMapList();
    }

    @Override
    public List<BdcZdFy> getBdcFyListByMap(HashMap hashMap) {
        return bdcFyMapper.getBdcFyListByMap(hashMap);
    }
}
