package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcGdDyhRelService;
import cn.gtmap.estateplat.config.core.service.GdFwService;
import cn.gtmap.estateplat.config.core.service.GdTdService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcGdDyhRel;
import cn.gtmap.estateplat.model.server.core.GdFw;
import cn.gtmap.estateplat.model.server.core.GdTd;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcGdDyhRelServiceImpl implements BdcGdDyhRelService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    GdFwService gdFwService;
    @Autowired
    GdTdService gdTdService;

    @Override
    public List<BdcGdDyhRel> getGdDyhRelListByGdid(String gdid) {
        List<BdcGdDyhRel> gdDyhRelList = null;
        if (StringUtils.isNotBlank(gdid)) {
            Example example = new Example(BdcGdDyhRel.class);
            example.createCriteria().andEqualTo("gdid", gdid);
            gdDyhRelList = entityMapper.selectByExample(example);
        }
        return gdDyhRelList;
    }

    @Override
    public List<BdcGdDyhRel> getGdDyhRelByGdproid(String gdproid) {
        List<BdcGdDyhRel> bdcGdDyhRelList = new ArrayList<BdcGdDyhRel>();
        if (StringUtils.isNotBlank(gdproid)) {
            List<GdFw> gdFwList = gdFwService.getGdFwByGdProid(gdproid);
            List<GdTd> gdTdList = gdTdService.getGdTdByProid(gdproid);

            if (CollectionUtils.isNotEmpty(gdFwList)) {
                for (GdFw gdFw : gdFwList) {
                    List<BdcGdDyhRel> gdDyhRelList = getGdDyhRelListByGdid(gdFw.getFwid());
                    if (CollectionUtils.isNotEmpty(gdDyhRelList))
                        bdcGdDyhRelList.addAll(gdDyhRelList);
                }
            }
            if (CollectionUtils.isNotEmpty(gdTdList)) {
                for (GdTd gdTd : gdTdList) {
                    List<BdcGdDyhRel> gdDyhRelList = getGdDyhRelListByGdid(gdTd.getTdid());
                    if (CollectionUtils.isNotEmpty(gdDyhRelList))
                        bdcGdDyhRelList.addAll(gdDyhRelList);
                }
            }
        }
        return bdcGdDyhRelList;
    }

    @Override
    public List<BdcGdDyhRel> listGdDyhRelByDyh(final String bdcydh) {
        List<BdcGdDyhRel> bdcGdDyhRelList = null;
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank(bdcydh)) {
            criteria.andEqualTo("bdcdyh", bdcydh);
            bdcGdDyhRelList = entityMapper.selectByExample(BdcGdDyhRel.class, example);
        }
        return bdcGdDyhRelList;
    }

    /**
     * @param tdid 土地id
     * @return ·
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 根据土地ID查询关系
     **/
    @Override
    public List<BdcGdDyhRel> listGdDyhRelByTdid(String tdid) {
        List<BdcGdDyhRel> bdcGdDyhRelList = null;
        Example example = new Example(BdcGdDyhRel.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtils.isNotBlank(tdid)) {
            criteria.andEqualTo("tdid", tdid);
            bdcGdDyhRelList = entityMapper.selectByExample(BdcGdDyhRel.class, example);
        }
        return bdcGdDyhRelList;
    }
}
