package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcGdxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.config.core.mapper.config.BdcGdxxMapper;
import cn.gtmap.estateplat.config.core.service.BdcGdxxService;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by zdd on 2016/1/7.
 */
@Service
public class BdcGdxxServiceImpl implements BdcGdxxService {
    @Autowired
    private EntityMapper entityMapper;
    
    @Autowired
    private BdcGdxxMapper bdcGdxxMapper;

    @Override
    @Transactional
    public void insertBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null) {
            if (StringUtils.isBlank(bdcGdxx.getGdxxid())) {
                bdcGdxx.setGdxxid(UUIDGenerator.generate18());
            }
            entityMapper.insertSelective(bdcGdxx);
        }
    }

    @Override
    @Transactional
    public void updateBdcGdxx(BdcGdxx bdcGdxx) {
        if (bdcGdxx != null && StringUtils.isNotBlank(bdcGdxx.getGdxxid())) {
            entityMapper.updateByPrimaryKeySelective(bdcGdxx);
        }
    }
    
    @Override
    public BdcGdxx initBdcGdxx(BdcGdxx bdcGdxx, final String gdxml) {

        try {
            if (StringUtils.isNotBlank(gdxml)) {
                Document document = DocumentHelper.parseText(gdxml);
                /**
                 * @author bianwen
                 * @description  判断归档成功或失败，解析追溯到list根节点
                 */
                Node listNode = document.selectSingleNode("//list");
                if (listNode != null) {
                    if (bdcGdxx == null) {
                        bdcGdxx = new BdcGdxx();
                        bdcGdxx.setGdxxid(UUIDGenerator.generate18());
                    }

                    Element listElement = (Element) listNode;
                    if (StringUtils.isNotBlank(listElement.attributeValue("result"))) {
                        //如果成功记录档案返回的基本信息
                        if (listElement.attributeValue("result").equals("succeed")) {
                            List<Node> archiveList = listNode.selectNodes("archive");
                            if (archiveList != null && archiveList.size() > 0) {
                                for (Node archive : archiveList) {
                                    Element archiveElement = (Element) archive;
                                    if (StringUtils.isNotBlank(archiveElement.attributeValue("result")) && archiveElement.attributeValue("result").equals("succeed")) {
                                        List<Node> fieldList = archiveElement.selectNodes("field");
                                        if (fieldList != null && fieldList.size() > 0) {
                                            for (Node field : fieldList) {
                                                Element fieldElement1 = (Element) field;
                                                String name = fieldElement1.attributeValue("name");
                                                if (name != null && name.equals("id")) {
                                                    bdcGdxx.setDaid(field.getText());
                                                }
                                                if (name != null && name.equals("ajh")) {
                                                    bdcGdxx.setAjh(field.getText());
                                                }
                                                if (name != null && name.equals("mlh")) {
                                                    bdcGdxx.setMlh(field.getText());
                                                }
                                            }
                                        }
                                        bdcGdxx.setGdxx(null);
                                    }
                                    else{
                                        if (StringUtils.isNotBlank(archiveElement.attributeValue("msg")))
                                            bdcGdxx.setGdxx(archiveElement.attributeValue("msg"));
                                    }
                                }
                            }

                        } else {
                            //zdd 记录失败的基本信息
                            if (StringUtils.isNotBlank(listElement.attributeValue("msg")))
                                bdcGdxx.setGdxx(listElement.attributeValue("msg"));
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return bdcGdxx;
    }

    /**
     * @param
     * @author bianwen
     * @return   list
     * @description  批量归档（多个archive）
     */
    @Override
    public List<BdcGdxx> initPlBdcGdxx(String gdxml) {
        List<BdcGdxx> gdxxList=new ArrayList<BdcGdxx>();

        try {
            if (StringUtils.isNotBlank(gdxml)) {
                Document document = DocumentHelper.parseText(gdxml);
                Node listNode = document.selectSingleNode("//list");
                if (listNode != null) {

                    Element listElement = (Element) listNode;
                    if (StringUtils.isNotBlank(listElement.attributeValue("result"))) {
                        //如果成功记录档案返回的基本信息
                        if (listElement.attributeValue("result").equals("succeed")) {
                            List<Node> archiveList = listNode.selectNodes("archive");
                            if (archiveList != null && archiveList.size() > 0) {
                                for (Node archive : archiveList) {
                                    BdcGdxx bdcGdxx = new BdcGdxx();
                                    bdcGdxx.setGdxxid(UUIDGenerator.generate18());
                                    bdcGdxx.setGdrq(new Date());
                                    Element archiveElement = (Element) archive;
                                    if (StringUtils.isNotBlank(archiveElement.attributeValue("result")) && archiveElement.attributeValue("result").equals("succeed")) {
                                        List<Node> fieldList = archiveElement.selectNodes("field");
                                        if (fieldList != null && fieldList.size() > 0) {
                                            for (Node field : fieldList) {
                                                Element fieldElement1 = (Element) field;
                                                String name = fieldElement1.attributeValue("name");
                                                if (name != null && name.equals("id")) {
                                                    bdcGdxx.setDaid(field.getText());
                                                }
                                                if (name != null && name.equals("ajh")) {
                                                    bdcGdxx.setAjh(field.getText());
                                                }
                                                if (name != null && name.equals("mlh")) {
                                                    bdcGdxx.setMlh(field.getText());
                                                }
                                                if (name != null && name.equals("proId")) {
                                                    bdcGdxx.setXmid(field.getText());
                                                }
                                            }
                                        }
                                        bdcGdxx.setGdxx(null);
                                    }
                                    else{
                                        if (StringUtils.isNotBlank(archiveElement.attributeValue("msg"))) {
                                            bdcGdxx.setGdxx(archiveElement.attributeValue("msg"));
                                        }
                                    }
                                    gdxxList.add(bdcGdxx);
                                }
                            }

                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return gdxxList;
    }

	/**
	 * @author wangtao
	 * @description
	 * @param 
	 * @return 
	 */
	@Override
	public boolean checkIsGd(final String proid) {
		int count=0;
    	count = bdcGdxxMapper.countXmid(proid);
    	if(count>0) {
    	   return false;	
    	}else {
    		return true;
    	}
	}

    /**
     * @author bianwen
     * @description  根据proid获取归档信息
     */
    @Override
    public BdcGdxx selectBdcGdxx(BdcXm bdcXm) {
        BdcGdxx bdcGdxx=null;
        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getProid()))
        {
            Example example=new Example(BdcGdxx.class);
            if(StringUtils.isNotBlank(bdcXm.getProid())) {

                example.createCriteria().andEqualTo("xmid",bdcXm.getProid());
                List <BdcGdxx> bdcGdxxList = entityMapper.selectByExample(BdcGdxx.class,example);
                if(CollectionUtils.isNotEmpty(bdcGdxxList)){
                    bdcGdxx=bdcGdxxList.get(0);
                }
            }
        }
        return bdcGdxx;
    }
}
