package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcHyMapper;
import cn.gtmap.estateplat.config.core.service.BdcHyService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcHy;
import cn.gtmap.estateplat.model.server.core.BdcHyFlxx;
import cn.gtmap.estateplat.model.server.core.BdcHyYhydzb;
import cn.gtmap.estateplat.model.server.core.DjsjZhxx;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/5/12
 * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
 * @description 不动产登记海域服务
 */
@Repository
public class BdcHyServiceImpl implements BdcHyService {

    @Autowired
    private BdcHyMapper bdcHyMapper;

    @Autowired
    private EntityMapper entityMapper;


    /**
     * 根据宗地宗海号查找bdc_hy
     *
     * @param zdzhh
     * @return
     */
    @Override
    @Transactional(readOnly = true)
    public BdcHy selectBdcHy(final String zdzhh) {
        return bdcHyMapper.selectBdcHy(zdzhh);
    }

    /**
     * 根据宗海信息获取bdc_hy
     *
     * @param djsjZhxx
     * @return bdc_hy
     */
    @Override
    public BdcHy getBdcHyFromZhxx(DjsjZhxx djsjZhxx) {
        BdcHy bdcHy = new BdcHy();
        if (null != djsjZhxx) {
            bdcHy.setHyid(UUIDGenerator.generate18());
            bdcHy.setZdzhh(djsjZhxx.getZhdm());
            if (StringUtils.isNotBlank(djsjZhxx.getMjdw())) {
                bdcHy.setMjdw(djsjZhxx.getMjdw());
            } else {
                bdcHy.setMjdw(Constants.DW_GQ);
            }
            bdcHy.setZhmj(djsjZhxx.getZhmj());
            //bdcHy.setYhlx(djsjZhxx.getYhlxa() + "\\" + djsjZhxx.getYhlxb());
            bdcHy.setYhlxa(djsjZhxx.getYhlxa());
            bdcHy.setYhlxb(djsjZhxx.getYhlxb());
            bdcHy.setZyax(StringUtils.contains("null", String.valueOf(djsjZhxx.getZhax())) ? "" : String.valueOf(djsjZhxx.getZhax()));
            bdcHy.setZyaxdw(Constants.DW_M);
            bdcHy.setYhzmj(djsjZhxx.getYhzmj());
            if (StringUtils.isNoneBlank(djsjZhxx.getDb())) {
                bdcHy.setHydb(Integer.parseInt(djsjZhxx.getDb()));
            }
            if (StringUtils.isNoneBlank(djsjZhxx.getBdcdyzt())) {
                bdcHy.setZt(Integer.parseInt(djsjZhxx.getBdcdyzt()));
            }
            bdcHy.setYhwzsm(djsjZhxx.getYhwzsm());
            bdcHy.setHdmc(djsjZhxx.getHdmc());
            bdcHy.setHddm(djsjZhxx.getHddm());
            bdcHy.setYdmj(djsjZhxx.getYdmj());
            bdcHy.setYdfw(djsjZhxx.getYdfw());
            bdcHy.setHdwz(djsjZhxx.getHdwz());
            bdcHy.setYt(djsjZhxx.getHdyt());
            bdcHy.setXmxz(djsjZhxx.getXmxz());
        }
        return bdcHy;
    }

    @Override
    public List<BdcHyFlxx> getHyflxxsFromBdcHy(BdcHy bdcHy) {
        List<BdcHyFlxx> bdcHyFlxxs = new ArrayList<BdcHyFlxx>();
        if (null != bdcHy) {
            String zdzhh = bdcHy.getZdzhh();
            if (StringUtils.isNotBlank(zdzhh)) {
                List<Map> zhJnbdyjlbs = bdcHyMapper.getFlxx(zdzhh);
                if (CollectionUtils.isNotEmpty(zhJnbdyjlbs)) {
                    for (Map map : zhJnbdyjlbs) {
                        BdcHyFlxx bdcHyFlxx = new BdcHyFlxx();
                        bdcHyFlxx.setHyflxxid(UUIDGenerator.generate18());
                        bdcHyFlxx.setHyid(bdcHy.getHyid());
                        if (map.get("YHFS") != null && StringUtils.isNotBlank(map.get("YHFS").toString())) {
                            bdcHyFlxx.setSyfs(map.get("YHFS").toString());
                        }
                        if (map.get("NBDY") != null && StringUtils.isNotBlank(map.get("NBDY").toString())) {
                            bdcHyFlxx.setJtyt(map.get("NBDY").toString());
                        }
                        if (map.get("SYJSE") != null && StringUtils.isNotBlank(map.get("SYJSE").toString())) {
                            bdcHyFlxx.setSyj(Double.parseDouble(map.get("SYJSE").toString()));
                        }
                        if (map.get("NBDYMJ") != null && StringUtils.isNotBlank(map.get("NBDYMJ").toString())) {
                            bdcHyFlxx.setMj(Double.parseDouble(map.get("NBDYMJ").toString()));
                        }
                        bdcHyFlxxs.add(bdcHyFlxx);
                    }
                }
            }
        }
        return bdcHyFlxxs;
    }

    @Override
    public List<BdcHyYhydzb> getYhydzbFromZhxx(DjsjZhxx djsjZhxx, BdcHy bdcHy) {
        List<BdcHyYhydzb> hyYhydzbs = new ArrayList<BdcHyYhydzb>();
        if (null != djsjZhxx && null != bdcHy && StringUtils.isNotBlank(djsjZhxx.getZhdm())) {
            String zdzhh = djsjZhxx.getZhdm();
            List<Map> zhJzbsbs = bdcHyMapper.getZhJzbsb(zdzhh);
            if (CollectionUtils.isNotEmpty(zhJzbsbs)) {
                for (Map map : zhJzbsbs) {
                    BdcHyYhydzb bdcHyYhydzb = new BdcHyYhydzb();
                    bdcHyYhydzb.setYhydzbid(UUIDGenerator.generate18());
                    bdcHyYhydzb.setZdzhh(djsjZhxx.getZhdm());
                    bdcHyYhydzb.setHyid(bdcHy.getHyid());
                    if (map.get("BW") != null && StringUtils.isNotBlank(map.get("BW").toString())) {
                        bdcHyYhydzb.setBw(map.get("BW").toString());
                    }
                    if (map.get("DJ") != null && StringUtils.isNotBlank(map.get("DJ").toString())) {
                        bdcHyYhydzb.setDj(map.get("DJ").toString());
                    }
                    if (map.get("XH") != null && StringUtils.isNotBlank(map.get("XH").toString())) {
                        bdcHyYhydzb.setXh(map.get("XH").toString());
                    }
                    hyYhydzbs.add(bdcHyYhydzb);
                }
            }
        }
        return hyYhydzbs;
    }


    @Override
    public void delBdcHyByZdzhh(final String zdzhh) {
        if (StringUtils.isNotBlank(zdzhh)) {
            Example example = new Example(BdcHy.class);
            example.createCriteria().andEqualTo("zdzhh", zdzhh);
            entityMapper.deleteByExample(example);
        }
    }

    @Override
    public void delYhydzbByZdzhh(final String zdzhh) {
        if (StringUtils.isNotBlank(zdzhh)) {
            Example example = new Example(BdcHyYhydzb.class);
            example.createCriteria().andEqualTo("zdzhh", zdzhh);
            entityMapper.deleteByExample(example);
        }
    }

    @Override
    public void delBdcHyFlxxByHyid(final String hyid) {
        if (StringUtils.isNotBlank(hyid)) {
            Example example = new Example(BdcHyFlxx.class);
            example.createCriteria().andEqualTo("hyid", hyid);
            entityMapper.deleteByExample(example);
        }
    }
}
