package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcMessageLogService;
import cn.gtmap.estateplat.config.model.BdcMessageLog;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
 * @version 2019/7/31
 * @description
 */
@Service
public class BdcMessageLogServiceImpl implements BdcMessageLogService {
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public void saveOrUpdateBdcMessageLog(BdcMessageLog bdcMessageLog) {
        if(bdcMessageLog != null&&StringUtils.isNotBlank(bdcMessageLog.getId())) {
            entityMapper.saveOrUpdate(bdcMessageLog,bdcMessageLog.getId());
        }
    }

    @Override
    public BdcMessageLog getBdcMessageLogById(String id) {
        BdcMessageLog bdcMessageLog = null;
        if(StringUtils.isNotBlank(id)) {
            bdcMessageLog = entityMapper.selectByPrimaryKey(BdcMessageLog.class,id);
        }
        return bdcMessageLog;
    }
}
