package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcQlrMapper;
import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZsService;
import cn.gtmap.estateplat.config.core.service.LogService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcQlrServiceImpl implements BdcQlrService {

    @Autowired
    private BdcQlrMapper bdcQlrMapper;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private LogService logService;

    @Override
    public List<Map> getQlrMcAndQlrZjhByProid(String proid, String qlrlx) {
        List<Map> mapList = null;
        if (StringUtils.isNotBlank(proid) || StringUtils.isNotBlank(qlrlx)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            hashMap.put("qlrlx", qlrlx);
            mapList = bdcQlrMapper.getBdcQlrMcAndZjhByMap(hashMap);
        }
        return mapList;
    }

    @Override
    public List<BdcQlr> getBdcQlrListByProidAndQlrlx(String proid, String qlrlx) {
        List<BdcQlr> bdcQlrList = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            if(StringUtils.isNotBlank(qlrlx)){
                hashMap.put("qlrlx", qlrlx);
            }
            bdcQlrList = bdcQlrMapper.getBdcQlrList(hashMap);
        }
        return bdcQlrList;
    }

    @Override
    public List<String> getQlrMcByProid(String proid, String qlrlx) {
        List<String> qlrmcList = null;
        if (StringUtils.isNotBlank(proid) || StringUtils.isNotBlank(qlrlx))
            qlrmcList = bdcQlrMapper.getQlrMcByProid(proid, qlrlx);
        return qlrmcList;
    }

    @Override
    public List<BdcQlr> getBdcQlrListByBdcqzh(String bdcqzh, String qlrlx) {
        List<BdcQlr> bdcQlrList = null;
        if (StringUtils.isNotBlank(bdcqzh)) {
            BdcXm bdcXm = bdcXmService.getBdcXmByBdcqzh(bdcqzh);
            if (bdcXm != null) {
                HashMap hashMap = new HashMap();
                hashMap.put("proid", bdcXm.getProid());
                if (StringUtils.isNotBlank(qlrlx))
                    hashMap.put("qlrlx", qlrlx);
                bdcQlrList = bdcQlrMapper.getBdcQlrList(hashMap);
            }
        }
        return bdcQlrList;
    }

    @Override
    public List<BdcQlr> queryBdcQlrByProid(String proid) {
        List<BdcQlr> list = new ArrayList<BdcQlr>();
        List<BdcQlr> tempList = queryBdcQlrYwrByProid(proid);
        if (tempList != null && tempList.size() > 0) {
            for (int i = 0; i < tempList.size(); i++) {
                BdcQlr bdcQlr = tempList.get(i);
                if (StringUtils.isNotBlank(bdcQlr.getQlrlx()) && bdcQlr.getQlrlx().equals(Constants.QLRLX_QLR)) {
                    list.add(bdcQlr);
                }
            }
        }
        return list;
    }

    @Override
    public List<BdcQlr> queryBdcQlrYwrByProid(String proid) {
        List<BdcQlr> list = new ArrayList<BdcQlr>();
        List<BdcQlr> tempList = new ArrayList<BdcQlr>();
        if (StringUtils.isNotBlank(proid)) {
            Example bdcQlrExample = new Example(BdcQlr.class);
            bdcQlrExample.createCriteria().andEqualTo("proid", proid);
            bdcQlrExample.setOrderByClause("sxh");
            tempList = entityMapper.selectByExample(bdcQlrExample);
        }

        if (tempList != null && tempList.size() > 0) {
            for (BdcQlr bdcQlr : tempList) {
                if (StringUtils.isBlank(bdcQlr.getQlrxz())) {
                    if (StringUtils.equals(bdcQlr.getQlrsfzjzl(), Constants.QLRZJHLX_ZZJG) || StringUtils.equals(bdcQlr.getQlrsfzjzl(), Constants.QLRZJHLX_YYZZ))
                        bdcQlr.setQlrxz(Constants.QLRXZ_QY);
                    else
                        bdcQlr.setQlrxz(Constants.QLRXZ_GR);
                }
                list.add(bdcQlr);
            }
        }
        return list;
    }

    @Override
    @Transactional
    public void deleteQlrByPrimaryKey(String ids) {
        if (StringUtils.isBlank(ids))
            return;
        /**
         * 根据主键循环删除数据库记录
         */
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            if (StringUtils.isNotBlank(id[i])) {
                if (entityMapper.selectByPrimaryKey(BdcQlr.class, id[i]) != null) {
                    logService.deleteLog(entityMapper.selectByPrimaryKey(BdcQlr.class, id[i]));
                    entityMapper.deleteByPrimaryKey(BdcQlr.class, id[i]);
                }
            }
        }
    }

    @Override
    public List<BdcQlr> findQlrByZsInfo(Map map) {
        return bdcQlrMapper.findQlrByZsInfo(map);
    }

    @Override
    public String combinationQlr(final List<BdcQlr> bdcQlrList) {
        StringBuilder qlrBuilder = new StringBuilder();
        List<String> qlridList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (StringUtils.isBlank(qlrBuilder.toString())) {
                    qlrBuilder.append(bdcQlr.getQlrmc());
                    qlridList.add(bdcQlr.getQlrid());
                } else if (!qlridList.contains(bdcQlr.getQlrid())) {
                    qlrBuilder.append("、").append(bdcQlr.getQlrmc());
                    qlridList.add(bdcQlr.getQlrid());
                }
            }
        }
        return qlrBuilder.toString();
    }

    @Override
    public List<BdcQlr> queryBdcYwrByProid(final String proid) {
        List<BdcQlr> list = new ArrayList<BdcQlr>();
        List<BdcQlr> tempList = queryBdcQlrYwrByProid(proid);
        if (tempList != null && tempList.size() > 0) {
            for (BdcQlr bdcQlr : tempList) {
                if (StringUtils.isNotBlank(bdcQlr.getQlrlx()) && bdcQlr.getQlrlx().equals(Constants.QLRLX_YWR)) {
                    list.add(bdcQlr);
                }
            }
        }
        return list;
    }

    @Override
    public String combinationYwr(final List<BdcQlr> bdcYwrList) {
        StringBuilder qlrBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(bdcYwrList)) {
            for (BdcQlr bdcQlr : bdcYwrList) {
                if (StringUtils.isBlank(qlrBuilder.toString())) {
                    qlrBuilder.append(bdcQlr.getQlrmc());
                } else {
                    qlrBuilder.append("、").append(bdcQlr.getQlrmc());
                }
            }
        }
        return qlrBuilder.toString();
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> getGyfsByProid(final String proid) {
        return bdcQlrMapper.getGyfsByProid(proid);
    }

    @Override
    @Transactional(readOnly = true)
    public String getGyqk(final String proid) {
        String gyqk = "";
        DecimalFormat df = (DecimalFormat) NumberFormat.getInstance();
        df.setMaximumFractionDigits(2);
        List<BdcQlr> bdcQlrList = queryBdcQlrByProid(proid);
        //共有方式按份共有中有共同共有
        if (isAfgyContainGtgy(bdcQlrList)) {
            for (BdcQlr bdcQlr : bdcQlrList) {
                if (bdcQlr != null) {
                    if (StringUtils.equals(bdcQlr.getGyfs(), "1")) continue;
                    String qlrString = new String();
                    if (StringUtils.isNotBlank(bdcQlr.getQlrmc())) {
                        qlrString = bdcQlr.getQlrmc();
                    }

                    if (StringUtils.isNotBlank(bdcQlr.getQygyr())) {
                        HashMap gyrMap = new HashMap();
                        gyrMap.put("proid", bdcQlr.getProid());
                        gyrMap.put("qlrlx", Constants.QLRLX_QLR);
                        gyrMap.put("qygyr", bdcQlr.getQygyr());
                        List<BdcQlr> gyrList = queryBdcQlrList(gyrMap);
                        if (CollectionUtils.isNotEmpty(gyrList)) {
                            for (BdcQlr gyr : gyrList) {
                                if (StringUtils.isNotBlank(qlrString)) {
                                    qlrString += "、" + gyr.getQlrmc();
                                } else {
                                    qlrString = gyr.getQlrmc();
                                }
                            }
                        }
                        qlrString = "(" + qlrString + ":" + Constants.GYFS_GTGY_MC + ")";
                    }

                    String qlbl = PublicUtil.percentage(bdcQlr.getQlbl());
                    //hzj  苏州当权利比例为1/3或其他数字描述时
                    if (StringUtils.isBlank(qlbl)) {
                        qlbl = bdcQlr.getQlbl();
                    }
                    if (StringUtils.isBlank(gyqk)) {
                        gyqk = qlrString + Constants.GYFS_AFGY_MC + qlbl;
                    } else {
                        gyqk = gyqk + "," + qlrString + Constants.GYFS_AFGY_MC + qlbl;
                    }
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(bdcQlrList) && StringUtils.isNotBlank(bdcQlrList.get(0).getGyfs()) && bdcQlrList.get(0).getGyfs().equals("2")) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    String qlbl = PublicUtil.percentage(bdcQlr.getQlbl());
                    //hzj  苏州当权利比例为1/3或其他数字描述时
                    if (StringUtils.isBlank(qlbl)) {
                        qlbl = bdcQlr.getQlbl();
                    }
                    if (bdcQlr != null) {
                        if (StringUtils.isBlank(gyqk)) {
                            gyqk = bdcQlr.getQlrmc() + ":" + qlbl;
                        } else {
                            gyqk = gyqk + " " + bdcQlr.getQlrmc() + ":" + qlbl;
                        }
                    }
                }
                gyqk = Constants.GYFS_AFGY_MC + ":" + gyqk;
            } else if (CollectionUtils.isNotEmpty(bdcQlrList) && StringUtils.isNotBlank(bdcQlrList.get(0).getGyfs()) && bdcQlrList.get(0).getGyfs().equals("1") && bdcQlrList.size() >= 2) {
                String qlrStirng = "";
                for (BdcQlr bdcQlr : bdcQlrList) {
                    if (StringUtils.isBlank(qlrStirng)) {
                        qlrStirng = bdcQlr.getQlrmc();
                    } else {
                        qlrStirng += "、" + bdcQlr.getQlrmc();
                    }
                }
                gyqk += qlrStirng;
                gyqk = Constants.GYFS_GTGY_MC + ":" + gyqk;
            }
        }

        if (StringUtils.isNotBlank(gyqk)) {
            if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                for (BdcQlr bdcQlr : bdcQlrList) {
                    bdcQlr.setGyqk(gyqk);
                    saveBdcQlr(bdcQlr);
                }
            }
        }

        return gyqk;
    }

    @Override
    public Boolean isAfgyContainGtgy(List<BdcQlr> bdcQlrList) {
        Boolean isAfgyContainGtgy = false;
        List<String> gyfsList = new ArrayList<String>();
        for (BdcQlr bdcQlr : bdcQlrList) {
            if (!gyfsList.contains(bdcQlr.getGyfs()) && StringUtils.isNotBlank(bdcQlr.getGyfs()))
                gyfsList.add(bdcQlr.getGyfs());
        }
        if (CollectionUtils.isNotEmpty(gyfsList) && gyfsList.size() == 2 && gyfsList.contains(Constants.GYFS_AFGY_DM) && gyfsList.contains(Constants.GYFS_GTGY_DM)) {
            isAfgyContainGtgy = true;
        }
        return isAfgyContainGtgy;
    }

    @Override
    @Transactional(readOnly = true)
    public List<BdcQlr> queryBdcQlrList(final Map map) {
        return bdcQlrMapper.queryBdcQlrList(map);
    }

    @Override
    public void saveBdcQlr(BdcQlr bdcQlr) {
        entityMapper.saveOrUpdate(bdcQlr, bdcQlr.getQlrid());
    }

    @Override
    public Map combinationQlrxxAndYwrxx(String proid) {
        Map resultMap = null;
        if(StringUtils.isNotBlank(proid)) {
            resultMap = Maps.newHashMap();
            List<BdcQlr> bdcQlrList = getBdcQlrListByProidAndQlrlx(proid, "");
            String qlr = "";
            String qlrzjzl = "";
            String qlrzjh = "";
            String ywr = "";
            String ywrzjzl = "";
            String ywrzjh = "";
            String gyfs = "";
            if(CollectionUtils.isNotEmpty(bdcQlrList)) {
                for (BdcQlr bdcQlr:bdcQlrList) {
                   if(StringUtils.equals(bdcQlr.getQlrlx(), Constants.QLRLX_QLR)) {
                       if(StringUtils.isNotBlank(bdcQlr.getQlrmc())) {
                           if(StringUtils.isNotBlank(qlr)) {
                               qlr += "," + bdcQlr.getQlrmc();
                           }else{
                               qlr = bdcQlr.getQlrmc();
                           }
                       }

                       if(StringUtils.isBlank(qlrzjzl)&&StringUtils.isNotBlank(bdcQlr.getQlrsfzjzl())) {
                           qlrzjzl = bdcQlr.getQlrsfzjzl();
                       }

                       if(StringUtils.isBlank(gyfs)&&StringUtils.isNotBlank(bdcQlr.getGyfs())) {
                           if(StringUtils.equals(bdcQlr.getGyfs(),Constants.GYFS_AFGY_DM)){
                               gyfs = Constants.GYFS_AFGY_DM;
                           }else{
                               gyfs = bdcQlr.getGyfs();
                           }
                       }


                       if(StringUtils.isNotBlank(bdcQlr.getQlrzjh())) {
                           if(StringUtils.isNotBlank(qlrzjh)) {
                               qlrzjh += "," + bdcQlr.getQlrzjh();
                           }else{
                               qlrzjh = bdcQlr.getQlrzjh();
                           }
                       }

                   } else if(StringUtils.equals(bdcQlr.getQlrlx(), Constants.QLRLX_YWR)) {
                       if(StringUtils.isNotBlank(bdcQlr.getQlrmc())) {
                           if(StringUtils.isNotBlank(ywr)) {
                               ywr += "," + bdcQlr.getQlrmc();
                           }else{
                               ywr = bdcQlr.getQlrmc();
                           }
                       }

                       if(StringUtils.isBlank(ywrzjzl)&&StringUtils.isNotBlank(bdcQlr.getQlrsfzjzl())) {
                           ywrzjzl = bdcQlr.getQlrsfzjzl();
                       }

                       if(StringUtils.isNotBlank(bdcQlr.getQlrzjh())) {
                           if(StringUtils.isNotBlank(ywrzjh)) {
                               ywrzjh += "," + bdcQlr.getQlrzjh();
                           }else{
                               ywrzjh = bdcQlr.getQlrzjh();
                           }
                       }
                   }
                }
            }

            resultMap.put("qlr",qlr);
            resultMap.put("qlrzjzl",qlrzjzl);
            resultMap.put("qlrzjh",qlrzjh);
            resultMap.put("ywr",ywr);
            resultMap.put("ywrzjzl",ywrzjzl);
            resultMap.put("ywrzjh",ywrzjh);
            resultMap.put("gyfs",gyfs);
        }
        return  resultMap;
    }
    @Override
    @Transactional
    public void delBdcQlrByQlrid(final String qlrid) {
        if (StringUtils.isNotBlank(qlrid)) {
            entityMapper.deleteByPrimaryKey(BdcQlr.class, qlrid);
        }
    }


}
