package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcRelMapper;
import cn.gtmap.estateplat.config.core.service.BdcRelService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQllxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjsyRel;
import cn.gtmap.estateplat.model.server.core.BdcSqlxDjzxRel;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/7/6.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcRelServiceImpl implements BdcRelService {

    @Autowired
    BdcRelMapper bdcRelMapper;
    @Autowired
    BdcZdGlService bdcZdGlService;
    @Autowired
    EntityMapper entityMapper;

    @Override
    public String getDjsyMcByQllx(String qllx) {
        String djsyMc = "";
        if (StringUtils.isNotBlank(qllx)) {
            HashMap hashMap = new HashMap();
            hashMap.put("qllx", qllx);
            List<BdcQllxDjsyRel> bdcQllxDjsyRelList = bdcRelMapper.getBdcQllxDjsyRelListByMap(hashMap);
            if (CollectionUtils.isNotEmpty(bdcQllxDjsyRelList)) {
                String djsy = bdcQllxDjsyRelList.get(0).getDjsydm();
                djsyMc = getDjsyMcByDjsy(djsy);
            }
        }
        return djsyMc;
    }

    @Override
    public String getDjsyMcByDjsy(String djsy) {
        String djsyMc = "";
        if (StringUtils.isNotBlank(djsy)) {
            if (djsy.contains("/")) {
                String[] djsyArray = djsy.split("/");
                for (String sy : djsyArray) {
                    String mc = bdcZdGlService.getBdcZdDjsyMcByDm(sy);
                    if (StringUtils.isNotBlank(djsyMc)) {
                        djsyMc += "/" + mc;
                    } else {
                        djsyMc = mc;
                    }
                }
            } else {
                djsyMc = bdcZdGlService.getBdcZdDjsyMcByDm(djsy);
            }
        }
        return djsyMc;
    }


    @Override
    public void saveOrUpdateBdcQllxDjsyRel(BdcQllxDjsyRel bdcQllxDjsyRel) {
        if (bdcQllxDjsyRel != null) {
            if (StringUtils.isBlank(bdcQllxDjsyRel.getId()))
                bdcQllxDjsyRel.setId(UUIDGenerator.generate());
            entityMapper.saveOrUpdate(bdcQllxDjsyRel, bdcQllxDjsyRel.getId());
        }
    }

    @Override
    public void delBdcQllxDjsyRel(String qllx) {
        if (StringUtils.isNotBlank(qllx))
            bdcRelMapper.delBdcQllxDjsyRel(qllx);
    }

    @Override
    public void saveOrUpdateBdcSqlxDjsyRel(BdcSqlxDjsyRel bdcSqlxDjsyRel) {
        if (StringUtils.isNotBlank(bdcSqlxDjsyRel.getSqlx())) {
//            Example example = new Example(BdcSqlxDjsyRel.class);
//            example.createCriteria().andEqualTo("sqlx", bdcSqlxDjsyRel.getSqlx());
//            List<BdcSqlxDjsyRel> bdcSqlxDjsyRelList = entityMapper.selectByExample(example);
//            if(CollectionUtils.isNotEmpty(bdcSqlxDjsyRelList)) {
//                BdcSqlxDjsyRel yBdcSqlxDjsyRel = bdcSqlxDjsyRelList.get(0);
//                bdcSqlxDjsyRel.setId(yBdcSqlxDjsyRel.getId());
//                String djsy = bdcSqlxDjsyRel.getDjsy();
//
//                bdcSqlxDjsyRel.setDjsy(djsy);
//                entityMapper.updateByPrimaryKeySelective(bdcSqlxDjsyRel);
//            } else {
            if (StringUtils.isBlank(bdcSqlxDjsyRel.getId()))
                bdcSqlxDjsyRel.setId(UUIDGenerator.generate());
            entityMapper.insertSelective(bdcSqlxDjsyRel);
//            }
        }
    }

    @Override
    public List<BdcSqlxDjzxRel> getDjzxDmBySqlxDm(String sqlx) {
        List<BdcSqlxDjzxRel> bdcSqlxDjzxRelList = null;
        if (StringUtils.isNotBlank(sqlx)) {
            Example example = new Example(BdcSqlxDjzxRel.class);
            example.createCriteria().andEqualTo("sqlxdm", sqlx);
            bdcSqlxDjzxRelList = entityMapper.selectByExample(example);

        }
        return bdcSqlxDjzxRelList;
    }

    @Override
    public void saveOrUpdateBdcSqlxYhRel(String id, String sqlx) {
        if (StringUtils.isNotBlank(id)) {
            bdcRelMapper.updateBdcSqlxYhRel(id, sqlx);
        } else {
            bdcRelMapper.saveBdcSqlxYhRel(UUIDGenerator.generate(), sqlx);
        }
    }

    @Override
    public void delBdcSqlxYhRel(String id) {
        if (StringUtils.isNotBlank(id))
            bdcRelMapper.delBdcSqlxYhRel(id);
    }

    @Override
    public List<HashMap> getBdcSqlxYhRelBySqlx(String sqlx) {
        List<HashMap> hashMapList = null;
        if (StringUtils.isNotBlank(sqlx)) {
            hashMapList = bdcRelMapper.getBdcSqlxYhRelBySqlx(sqlx);
        }
        return hashMapList;
    }

    @Override
    public List<BdcSqlxDjsyRel> getBdcSqlxDjsyRelListBySqlxAndDjsy(String sqlx, String djsy) {
        List<BdcSqlxDjsyRel> bdcSqlxDjsyRelList = null;
        if (StringUtils.isNotBlank(sqlx) || StringUtils.isNotBlank(djsy)) {
            HashMap hashMap = new HashMap();
            hashMap.put("sqlx", sqlx);
            hashMap.put("djsy", djsy);
            bdcSqlxDjsyRelList = bdcRelMapper.getBdcSqlxDjsyRelListByMap(hashMap);
        }
        return bdcSqlxDjsyRelList;
    }

    @Override
    public List<BdcQllxDjsyRel> getBdcQllxDjsyRelByQllxAndDjsy(String qllx, String djsy) {
        List<BdcQllxDjsyRel> bdcQllxDjsyRelList = null;
        if (StringUtils.isNotBlank(qllx) || StringUtils.isNotBlank(djsy)) {
            HashMap hashMap = new HashMap();
            hashMap.put("qllx", qllx);
            hashMap.put("djsy", djsy);
            bdcQllxDjsyRelList = bdcRelMapper.getBdcQllxDjsyRelListByMap(hashMap);
        }
        return bdcQllxDjsyRelList;
    }

    @Override
    public void delBdcQllxDjsyRelById(String id) {
        entityMapper.deleteByPrimaryKey(BdcQllxDjsyRel.class, id);
    }

    @Override
    public List<BdcSqlxDjzxRel> getBdcSqlxDjzxRelBySqlxOrDjzx(String sqlx, String djzx) {
        List<BdcSqlxDjzxRel> bdcSqlxDjzxRelList = null;
        if (StringUtils.isNotBlank(sqlx) || StringUtils.isNotBlank(djzx)) {
            Example example = new Example(BdcSqlxDjzxRel.class);
            Example.Criteria criteria = example.createCriteria();
            if (StringUtils.isNotBlank(sqlx))
                criteria.andEqualTo("sqlxdm", sqlx);
            if (StringUtils.isNotBlank(djzx))
                criteria.andEqualTo("djzxdm", djzx);
            bdcSqlxDjzxRelList = entityMapper.selectByExample(example);
        }
        return bdcSqlxDjzxRelList;
    }

    @Override
    public boolean getDataByClass(Object obj, String[] fieldNames) {
        boolean hasData = false;
        if (obj != null) {
            Class objClass = obj.getClass();
            Example example = new Example(objClass);
            Example.Criteria criteria = example.createCriteria();
            Field[] fields = objClass.getFields();
            for (Field field : fields) {
                Object value = getObjData(obj, objClass, field.getName());
                if (fieldNames != null) {
                    for (String name : fieldNames) {
                        if (StringUtils.equals(name, field.getName())) {
                            if (value != null) {
                                criteria.andEqualTo(field.getName(), value);
                            } else {
                                criteria.andIsNull(field.getName());
                            }
                        }
                    }
                } else {
                    if (value != null) {
                        criteria.andEqualTo(field.getName(), value);
                    } else {
                        criteria.andIsNull(field.getName());
                    }
                }
            }
            List<?> objList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(objList))
                hasData = true;
        }
        return hasData;
    }

    public Object getObjData(Object obj, Class objClass, String name) {
        Object value = "";
        try {
            String firstLetter = name.substring(0, 1).toUpperCase();
            String getMethod = "get" + firstLetter + name.substring(1);
            Method method = objClass.getMethod(getMethod);
            value = method.invoke(obj, new Object[]{});
        } catch (Exception e) {

        }
        return value;
    }
}
