package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcSjclMapper;
import cn.gtmap.estateplat.config.core.service.BdcSjclService;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcSjclServiceImpl implements BdcSjclService {

    @Autowired
    BdcSjclMapper bdcSjclMapper;

    @Override
    public List<BdcSjcl> getBdcSjclByproid(String proid) {
        List<BdcSjcl> bdcSjclList = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            bdcSjclList = bdcSjclMapper.getBdcSjclListByBdcSjxx(hashMap);
        }
        return bdcSjclList;
    }
}
