package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcSjdService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSjcl;
import cn.gtmap.estateplat.model.server.core.BdcSjxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-19
 */
@Service
public class BdcSjdServiceImpl implements BdcSjdService {
    @Autowired
    EntityMapper entityMapper;
    @Override
    public BdcSjxx createSjxxByBdcxm(BdcXm bdcXm) {
        BdcSjxx bdcSjxx = new BdcSjxx();
        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getWiid())) {
            List<BdcSjxx> bdcSjxxList = queryBdcSjdByWiid(bdcXm.getWiid());
            if (bdcSjxxList == null || bdcSjxxList.size() == 0) {
                bdcSjxx.setSjxxid(UUIDGenerator.generate());
                bdcSjxx.setProid(bdcXm.getProid());
                bdcSjxx.setWiid(bdcXm.getWiid());
                bdcSjxx.setSjr(bdcXm.getCjr());
                bdcSjxx.setSjrq(bdcXm.getCjsj());
                addBdcSjxx(bdcSjxx);
            }
        }
        return bdcSjxx;
    }
    @Override
    @Transactional(readOnly = true)
    public List<BdcSjxx> queryBdcSjdByWiid(final String wiid) {
        List<BdcSjxx> bdcSjxxList = null;
        if (StringUtils.isNotBlank(wiid)) {
            Example bdcSjxx = new Example(BdcSjxx.class);
            bdcSjxx.createCriteria().andEqualTo("wiid", wiid);
            bdcSjxxList = entityMapper.selectByExample(BdcSjxx.class, bdcSjxx);
        }
        return bdcSjxxList;
    }
    @Override
    @Transactional
    public void addBdcSjxx(BdcSjxx bdcSjxx) {
        if (bdcSjxx != null) {
            if (StringUtils.isBlank(bdcSjxx.getSjxxid()))
                bdcSjxx.setSjxxid(UUIDGenerator.generate());
            entityMapper.insertSelective(bdcSjxx);
        }
    }
    @Override
    @Transactional
    public void delSjclListBySjxxid(final String sjxxid) {
        if (StringUtils.isNotBlank(sjxxid)) {
            Example bdcSjcl = new Example(BdcSjcl.class);
            bdcSjcl.createCriteria().andEqualTo("sjxxid", sjxxid);
            entityMapper.deleteByExample(BdcSjcl.class, bdcSjcl);
        }

    }

    @Override
    @Transactional
    public void delBdcSjxxBySjxxid(final String sjxxid) {
        if (StringUtils.isNotBlank(sjxxid))
            entityMapper.deleteByPrimaryKey(BdcSjxx.class, sjxxid);
    }

}
