package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcSpxxService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcSpxx;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @version 1.0, 2017/6/30.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcSpxxServiceImpl implements BdcSpxxService {
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private BdcXmService bdcXmService;

    @Override
    public BdcSpxx getBdcSpxxByProid(String proid) {
        BdcSpxx bdcSpxx = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcSpxx.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcSpxx> bdcSpxxList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcSpxxList))
                bdcSpxx = bdcSpxxList.get(0);
        }
        return bdcSpxx;
    }

    @Override
    public void saveBdcSpxx(BdcSpxx bdcSpxx) {
        //处理从前台获取的不动产单元进行去空
        if (StringUtils.isNotBlank(bdcSpxx.getBdcdyh())) {
            String newBdcdy = bdcSpxx.getBdcdyh().replaceAll(" ", "");
            bdcSpxx.setBdcdyh(newBdcdy);
        }
        entityMapper.saveOrUpdate(bdcSpxx, bdcSpxx.getSpxxid());
        if (StringUtils.isNotBlank(bdcSpxx.getProid())) {
            Boolean isHb = bdcXmService.isHb(bdcSpxx.getProid());
            BdcXm bdcXm = bdcXmService.getBdcXmByProid(bdcSpxx.getProid());
            if (isHb) {
                if (StringUtils.isNotBlank(bdcXm.getWiid())) {
                    List<BdcSpxx> bdcSpxxList = getBdcSpxxByWiid(bdcXm.getWiid());
                    for (BdcSpxx saveBdcSpxx : bdcSpxxList) {
                        //防止土地分割合并出现多个不动产单元的情况保存为同一个不动产单号的审批信息
                        if (StringUtils.isNotBlank(bdcSpxx.getBdcdyh()) && StringUtils.equals(bdcSpxx.getBdcdyh(), saveBdcSpxx.getBdcdyh())) {
                            bdcSpxx.setProid(saveBdcSpxx.getProid());
                            bdcSpxx.setSpxxid(saveBdcSpxx.getSpxxid());
                            entityMapper.saveOrUpdate(bdcSpxx, bdcSpxx.getSpxxid());
                        }
                    }
                }
            } else {
                entityMapper.saveOrUpdate(bdcSpxx, bdcSpxx.getSpxxid());
            }
        }
    }

    @Override
    public List<BdcSpxx> getBdcSpxxByWiid(String wiid) {
        List<BdcXm> bdcXmList = null;
        ArrayList list = new ArrayList();
        if (StringUtils.isNotBlank(wiid)) {
            bdcXmList = bdcXmService.getBdcXmListByWiid(wiid);
        }
        if (bdcXmList != null && bdcXmList.size() > 0) {
            for (BdcXm bdcXm : bdcXmList) {
                if (StringUtils.isNotBlank(bdcXm.getProid())) {
                    Example example = new Example(BdcSpxx.class);
                    Example.Criteria criteria = example.createCriteria();
                    criteria.andEqualTo("proid", bdcXm.getProid());
                    List<BdcSpxx> bdcSpxxList1 = entityMapper.selectByExample(BdcSpxx.class, example);
                    if (bdcSpxxList1 != null && bdcSpxxList1.size() > 0) {
                        list.addAll(bdcSpxxList1);
                    }
                }
            }
        }
        return list;
    }
    @Override
    @Transactional
    public void delBdcSpxxByProid(String proid) {
        if (StringUtils.isNotBlank(proid)) {
            Example bdcSpxx = new Example(BdcSpxx.class);
            bdcSpxx.createCriteria().andEqualTo("proid", proid);
            entityMapper.deleteByExample(BdcSpxx.class, bdcSpxx);
        }
    }
}
