package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcTdMapper;
import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcTdService;
import cn.gtmap.estateplat.config.core.service.BdcdyService;
import cn.gtmap.estateplat.config.core.service.DjsjService;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author zzhw
 * @version V1.0, 15-3-18
 */
@Repository
public class BdcTdServiceImpl implements BdcTdService {
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcTdMapper bdcTdMapper;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private DjsjService djsjService;

    @Override
    public void delBdcTdByZdzhh(final String zdzhh) {
        if (StringUtils.isNotBlank(zdzhh)) {
            Example example = new Example(BdcTd.class);
            example.createCriteria().andEqualTo("zdzhh", zdzhh);
            entityMapper.deleteByExample(example);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public BdcTd selectBdcTd(final String zdzhh) {
        return bdcTdMapper.selectBdcTd(zdzhh);
    }

    /**
     * @param
     * @return
     * @author wangtao
     * @description
     */
    @Override
    public List<Map> getZdty() {
        return bdcTdMapper.getZdyt();
    }

    @Override
    public List<Map> getBdcZdxxList(String proid) {
        return bdcTdMapper.getBdcZdxxList(proid);
    }

    @Override
    public BdcTd getBdcTdFromDjxx(InitVoFromParm initVoFromParm, String djh) {
        DjsjZdxx djsjZdxx = initVoFromParm.getDjsjZdxx();
        List<DjsjQszdDcb> djsjQszdDcbList = initVoFromParm.getDjsjQszdDcbList();
        List<DjsjNydDcb> djsjNydDcbList = initVoFromParm.getDjsjNydDcbList();
        if (djsjZdxx == null && CollectionUtils.isEmpty(djsjQszdDcbList) && CollectionUtils.isEmpty(djsjNydDcbList))
            return null;
        BdcTd bdcTd = null;
        if (StringUtils.isNoneBlank(djh)) {
            if (djsjZdxx != null) {
                bdcTd = new BdcTd();
                bdcTd.setTdid(UUIDGenerator.generate18());
                bdcTd.setZdzhh(djh);
                bdcTd.setQlxz(djsjZdxx.getSyqlx());
                if (djsjZdxx.getFzmj() != null && djsjZdxx.getFzmj() != 0) {
                    bdcTd.setZdmj(djsjZdxx.getFzmj());
                } else {
                    bdcTd.setZdmj(djsjZdxx.getScmj());
                }
                bdcTd.setQlsdfs(djsjZdxx.getQlsdfs());
                bdcTd.setYt(djsjZdxx.getTdyt());
                bdcTd.setQllx(djsjZdxx.getQsxz());
                bdcTd.setRjl(djsjZdxx.getJzrjl());
                bdcTd.setJzmd(djsjZdxx.getJzmd());
                bdcTd.setJzxg(djsjZdxx.getJzxg());
                bdcTd.setJg(djsjZdxx.getQdjg());
                bdcTd.setDj(djsjZdxx.getTdjb());
                //zdd 地籍没有单位  默认就是平方米
                bdcTd.setMjdw(djsjZdxx.getMjdw());
            } else if (CollectionUtils.isNotEmpty(djsjQszdDcbList)) {
                DjsjQszdDcb djsjQszdDcb = djsjQszdDcbList.get(0);
                if (djsjQszdDcb != null) {
                    bdcTd = new BdcTd();
                    bdcTd.setTdid(UUIDGenerator.generate18());
                    bdcTd.setZdzhh(djh);
                    if (djsjQszdDcb.getFzmj() != null && djsjQszdDcb.getFzmj() != 0) {
                        bdcTd.setZdmj(djsjQszdDcb.getFzmj());
                    } else {
                        bdcTd.setZdmj(djsjQszdDcb.getScmj());
                    }
                    bdcTd.setQlxz(djsjQszdDcb.getSyqlx());
                    bdcTd.setQlsdfs(djsjQszdDcb.getQlsdfs());
                    bdcTd.setYt(djsjQszdDcb.getTdyt());
                    bdcTd.setQllx(djsjQszdDcb.getQsxz());
                    bdcTd.setZl(djsjQszdDcb.getTdzl());
                    bdcTd.setMjdw(djsjQszdDcb.getMjdw());
                }
            } else if (CollectionUtils.isNotEmpty(djsjNydDcbList)) {
                DjsjNydDcb djsjNydDcb = djsjNydDcbList.get(0);
                if (djsjNydDcb != null) {
                    bdcTd = new BdcTd();
                    bdcTd.setTdid(UUIDGenerator.generate18());
                    bdcTd.setZdzhh(djh);
                    if (djsjNydDcb.getFzmj() != null && djsjNydDcb.getFzmj() != 0) {
                        bdcTd.setZdmj(djsjNydDcb.getFzmj());
                    } else {
                        bdcTd.setZdmj(djsjNydDcb.getScmj());
                    }
                    bdcTd.setRjl(djsjNydDcb.getJzrjl());
                    bdcTd.setJzmd(djsjNydDcb.getJzmd());
                    bdcTd.setJzxg(djsjNydDcb.getJzxg());
                    bdcTd.setYt(djsjNydDcb.getTdyt());
                    bdcTd.setQlsdfs(djsjNydDcb.getQlsdfs());
                    bdcTd.setQlxz(djsjNydDcb.getSyqlx());
                    bdcTd.setQllx(djsjNydDcb.getQsxz());
                    //bdcTd.setDj(djsjNydDcb.getDj());
                    bdcTd.setJg(djsjNydDcb.getQdjg());
                    bdcTd.setZl(djsjNydDcb.getTdzl());
                    bdcTd.setMjdw(djsjNydDcb.getMjdw());
                }
            }
        }
        return bdcTd;
    }

    @Override
    public List<String> getProidListByBdcdyid(String bdcdyid) {
        return bdcTdMapper.getProidListByBdcdyid(bdcdyid);
    }

    @Override
    public String getZdLb(String proid) {
        String zdTzm = StringUtils.EMPTY;
        String zdLb = StringUtils.EMPTY;
        //通过proid获取不动产单元号
        BdcBdcdy bdcBdcdy = bdcdyService.queryBdcBdcdyByProid(proid);
        String bdcdyh="";
        if(bdcBdcdy!=null )
            bdcdyh=bdcBdcdy.getBdcdyh();
        if (StringUtils.isNotBlank(bdcdyh)) {
            //截取不动产单元号的12-13位为宗地特征码
            zdTzm = bdcdyh.substring(12, 14);
            //截取不动产单元号的0-18位为宗地宗海号
        }
        //获取BDC_XT_ZDLB_CONFIG表中配置的宗地类别判定方式
        HashMap<String, String> resultMap = bdcTdMapper.getFsAndDefaultZdLbByZdTzm(zdTzm);
        if (resultMap == null) {
            resultMap = new HashMap<String, String>();
        }
        String fs = StringUtils.EMPTY;
        String defaultZdLb = StringUtils.EMPTY;
        if (!resultMap.isEmpty()) {
            //FS 宗地判定方式
            if (StringUtils.isNotBlank(resultMap.get("FS"))) {
                fs = resultMap.get("FS");
            }
            //ZDLB 宗地类别
            if (StringUtils.isNotBlank(resultMap.get("ZDLB"))) {
                defaultZdLb = resultMap.get("ZDLB");
            }
        } else {
            resultMap = bdcTdMapper.getFsAndDefaultZdLbByZdTzm(Constants.ZDTZM_DEFAULT);
            if (resultMap != null) {
                defaultZdLb = resultMap.get("ZDLB");
                if (StringUtils.isNotBlank(resultMap.get("FS"))) {
                    fs = resultMap.get("FS");
                }
            }
        }
        if (StringUtils.isBlank(defaultZdLb))
            defaultZdLb = Constants.ZDLB_DYZ;
        if (StringUtils.isNotBlank(fs)) {
            //不动产单元方式,根据宗地上不动产单元数量判定是独有宗还是共有宗
            if (StringUtils.equals(StringUtils.upperCase(fs), Constants.ZDLB_PDFS_BDCDY)) {
                int bdcdyCount = djsjService.queryBdcdyCountByDjh(StringUtils.substring(bdcdyh, 0, 19));
                if (bdcdyCount == 1 || bdcdyCount == 0) {
                    zdLb = Constants.ZDLB_DYZ;
                } else {
                    zdLb = Constants.ZDLB_GYZ;
                }
                //权利人方式,根据proid获取权利人数量,通过权利人数量判定是独有宗还是共有宗
            } else if (StringUtils.equals(StringUtils.upperCase(fs), Constants.ZDLB_PDFS_QLR)) {
                List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(proid);
                if (CollectionUtils.isNotEmpty(bdcQlrList)) {
                    if (bdcQlrList.size() == 1) {
                        zdLb = Constants.ZDLB_DYZ;
                    } else {
                        zdLb = Constants.ZDLB_GYZ;
                    }
                }
            } else if (StringUtils.equals(StringUtils.upperCase(fs), "BDCDYFWLX")) {
                List<String> bdcfwlxList = djsjService.getBdcfwlxByBdcdyh(bdcdyh);
                if (CollectionUtils.isNotEmpty(bdcfwlxList)) {
                    if (StringUtils.equals(bdcfwlxList.get(0), "4"))
                        zdLb = Constants.ZDLB_GYZ;
                    else
                        zdLb = Constants.ZDLB_DYZ;
                }
            }
        } else {
            zdLb = defaultZdLb;
        }
        return zdLb;
    }

    @Override
    public String changeMjByZdLb(final String zdLb, final String mj,final String bdclx) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotBlank(zdLb)) {
            if (StringUtils.equals(Constants.ZDLB_DYZ, zdLb)) {
                for (String string : mj.split("/")) {
                    if (string.indexOf("共有宗地") > -1) {
                        string = StringUtils.replace(string, "共有宗地", "宗地");
                    }
                    if (!(StringUtils.equals(bdclx, "FW")) || StringUtils.indexOf(string, "房屋") > -1) {
                        stringBuilder.append(string);
                        stringBuilder.append("/");
                    }
                }
            } else if (StringUtils.equals(Constants.ZDLB_GYZ, zdLb)) {
                for (String string : mj.split("/")) {
                    if (string.indexOf("宗地") > -1 && string.indexOf("共有宗地") < 0) {
                        string = StringUtils.replace(string, "宗地", "共有宗地");
                    }
                    //jyl南通需求
                    if (string.indexOf("建筑面积") > -1) {
                        string = StringUtils.replace(string, "建筑面积", "面积");
                    }
                    if (!(StringUtils.equals(bdclx, "FW")) || StringUtils.indexOf(string, "房屋") > -1) {
                        stringBuilder.append(string);
                        stringBuilder.append("/");
                    }
                }
            }
        }
        if (stringBuilder != null && stringBuilder.toString().length() > 0)
            return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
        else
            return "";
    }
}
