package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXmRelMapper;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcXmRel;
import cn.gtmap.estateplat.model.server.core.BdcXmzsRel;
import cn.gtmap.estateplat.model.server.core.Project;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcXmRelServiceImpl implements BdcXmRelService {
    @Autowired
    BdcXmRelMapper bdcXmRelMapper;

    @Autowired
    private EntityMapper entityMapper;
    @Override
    public List<BdcXmRel> getBdcXmRelByProid(String proid) {
        List<BdcXmRel> bdcXmRelList = null;
        if (StringUtils.isNotBlank(proid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            bdcXmRelList = bdcXmRelMapper.getBdcXmRelByMap(hashMap);
        }
        return bdcXmRelList;
    }

    /**
     * @param proid 不动产登记项目ID
     * @return 上一手不动产登记项目ID
     * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
     * @description 根据不动产登记项目ID获取上一手不动产登记项目ID
     */
    @Override
    @Transactional(readOnly = true)
    public String getYproid(final String proid) {
        return bdcXmRelMapper.getYproid(proid);
    }


    @Override
    @Transactional(readOnly = true)
    public List<BdcXmRel> getBdcXmRelByYproidAndBdcdyh(String yproid, String bdcdyh) {
        List<BdcXmRel> bdcXmRelList = null;
        if (StringUtils.isNotBlank(yproid) || StringUtils.isNotBlank(bdcdyh)) {
            HashMap hashMap = new HashMap();
            hashMap.put("yproid", yproid);
            hashMap.put("bdcdyh", bdcdyh);
            bdcXmRelList = bdcXmRelMapper.getBdcXmRelByBdcdyAndBdcXm(hashMap);
        }
        return bdcXmRelList;
    }

    /**
     * @param wiid
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过wiid获取相应的bdc_xm_rel数据
     **/
    @Override
    public List<BdcXmRel> listBdcXmRelByWiid(String wiid){
        return bdcXmRelMapper.listBdcXmRelByWiid(wiid);
    }
    @Override
    @Transactional
    public void delBdcXmRelByProid(final String proid) {
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo("proid", proid);
            entityMapper.deleteByExample(BdcXmRel.class, example);
        }
    }


    @Override
    public BdcXmRel creatBdcXmRelFromProject(Project project) {
        BdcXmRel bdcXmRel = new BdcXmRel();

        bdcXmRel.setProid(project.getProid());

        bdcXmRel.setQjid(project.getDjId());

        //过渡数据和原项目的Yproid赋值区分
        if (StringUtils.isNotBlank(project.getYxmid())) {
            bdcXmRel.setYproid(project.getYxmid());
        } else {
            bdcXmRel.setYproid(project.getGdproid());
        }
        bdcXmRel.setYdjxmly(project.getXmly());
        bdcXmRel.setYqlid(project.getYqlid());

        if (StringUtils.isNotBlank(project.getProid())) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo("proid", project.getProid());
            //entityMapper.deleteByExample(example);
        }
        //zdd 此处代码无意义  前面已经删除了  所以百分百找不到
        bdcXmRel.setRelid(UUIDGenerator.generate18());
        return bdcXmRel;
    }



}
