package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXmMapper;
import cn.gtmap.estateplat.config.core.service.BdcSqlxDjsyRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.BdcXmService;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.config.utils.PlatformUtil;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CalendarUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.plat.service.SysCalendarService;
import com.gtis.plat.service.SysWorkFlowInstanceService;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;
import com.gtis.plat.vo.UserInfo;
import com.gtis.plat.wf.model.ActivityModel;
import com.gtis.web.SessionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcXmServiceImpl implements BdcXmService {

    @Autowired
    private BdcXmMapper bdcXmMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcSlbhServiceContext bdcSlbhServiceContext;
    @Autowired
    private BdcSqlxDjsyRelService bdcSqlxDjsyRelService;
    @Autowired
    private BdcZdGlService bdcZdGlService;
    @Autowired
    private SysWorkFlowInstanceService sysWorkFlowInstanceService;
    @Autowired
    private SysCalendarService sysCalendarService;
    @Autowired
    private BdcXmRelService bdcXmRelService;

    @Override
    public Project getProjectFromBdcXm(BdcXm bdcXm, Project project) {
        if (project == null) {
            project = new Project();
        }
        if (bdcXm != null) {
            if (StringUtils.isNotBlank(bdcXm.getBdclx())) {
                project.setBdclx(bdcXm.getBdclx());
            }
            if (StringUtils.isNotBlank(bdcXm.getBh())) {
                project.setBh(bdcXm.getBh());
            }
            if (bdcXm.getBjsj() != null) {
                project.setBjsj(bdcXm.getBjsj());
            }
            if (StringUtils.isNotBlank(bdcXm.getBz())) {
                project.setBz(bdcXm.getBz());
            }
            if (StringUtils.isNotBlank(bdcXm.getCjr())) {
                project.setCjr(bdcXm.getCjr());
            }
            if (StringUtils.isNotBlank(bdcXm.getDjlx())) {
                project.setDjlx(bdcXm.getDjlx());
            }
            if (bdcXm.getCjsj() != null) {
                project.setCjsj(bdcXm.getCjsj());
            }
            if (StringUtils.isNotBlank(bdcXm.getDjyy())) {
                project.setDjyy(bdcXm.getDjyy());
            }
            if (StringUtils.isNotBlank(bdcXm.getDwdm())) {
                project.setDwdm(bdcXm.getDwdm());
            }
            if (StringUtils.isNotBlank(bdcXm.getWiid())) {
                project.setWiid(bdcXm.getWiid());
            }
            if (StringUtils.isNotBlank(bdcXm.getLsh())) {
                project.setLsh(bdcXm.getLsh());
            }
            if (StringUtils.isNotBlank(bdcXm.getNf())) {
                project.setNf(bdcXm.getNf());
            }
            if (StringUtils.isNotBlank(bdcXm.getProid())) {
                project.setProid(bdcXm.getProid());
            }
            if (StringUtils.isNotBlank(bdcXm.getDjyy())) {
                project.setDjyy(bdcXm.getDjyy());
            }
            if (StringUtils.isNotBlank(bdcXm.getSqfbcz())) {
                project.setSqfbcz(bdcXm.getSqfbcz());
            }
            if (StringUtils.isNotBlank(bdcXm.getSqzsbs())) {
                project.setSqzsbs(bdcXm.getSqzsbs());
            }

            if (StringUtils.isNotBlank(bdcXm.getSqrsm())) {
                project.setSqrsm(bdcXm.getSqrsm());
            }
            if (StringUtils.isNotBlank(bdcXm.getXmly())) {
                project.setXmly(bdcXm.getXmly());
            }
            if (StringUtils.isNotBlank(bdcXm.getXmmc())) {
                project.setXmmc(bdcXm.getXmmc());
            }
            if (StringUtils.isNotBlank(bdcXm.getXmzt())) {
                project.setXmzt(bdcXm.getXmzt());
            }
            if (StringUtils.isNotBlank(bdcXm.getQllx())) {
                project.setQllx(bdcXm.getQllx());
            }
            if (StringUtils.isNotBlank(bdcXm.getBdcdyid())) {
                project.setBdcdyid(bdcXm.getBdcdyid());
            }
            if (StringUtils.isNotBlank(bdcXm.getSqlx())) {
                project.setSqlx(bdcXm.getSqlx());
            }
            if (StringUtils.isNotBlank(bdcXm.getDjsy())) {
                project.setDjsy(bdcXm.getDjsy());
            }
            if (bdcXm.getCjsj() != null) {
                project.setCjsj(bdcXm.getCjsj());
            } else {
                project.setCjsj(new Date());
            }
            if (StringUtils.isNotBlank(bdcXm.getXmly())) {
                project.setXmly(bdcXm.getXmly());
            }

            if (StringUtils.isNotBlank(bdcXm.getYbh())) {
                project.setYbh(bdcXm.getYbh());
            }
            if (StringUtils.isNotBlank(bdcXm.getBlyzh())) {
                project.setBlyzh(bdcXm.getBlyzh());
            }

            /**
             * @author bianwen
             * @description 查封强制验证要判断登记子项
             */
            if (StringUtils.isNotBlank(bdcXm.getDjzx())) {
                project.setDjzx(bdcXm.getDjzx());
            }
        }
        return project;
    }

    @Override
    public List<BdcXm> getBdcXmByBdcdyh(String bdcdyh) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcdyh", bdcdyh);
            bdcXmList = bdcXmMapper.getBdcXmByBdcBdcdy(hashMap);
        }
        return bdcXmList;
    }

    @Override
    public List<BdcXm> getCdBdcXmByBdcdyh(String bdcdyh) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            bdcXmList = bdcXmMapper.getCdBdcXmProidByBdcdyh(bdcdyh, Constants.SQLX_SFCD);
        }
        return bdcXmList;
    }

    @Override
    public BdcXm getBdcXmByProid(String proid) {
        BdcXm bdcXm = new BdcXm();
        if (StringUtils.isNotBlank(proid)) {
            bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, proid);
        }
        return bdcXm;
    }

    @Override
    public List<BdcXm> getBdcXmListByWiid(String wiid) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(wiid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("wiid", wiid);
            bdcXmList = bdcXmMapper.getBdcXmList(hashMap);
        }
        return bdcXmList;
    }

    @Override
    public List<BdcXm> getBdcXmByBdcdyid(String bdcdyid) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(bdcdyid)) {
            Example example = new Example(BdcXm.class);
            example.createCriteria().andEqualTo("bdcdyid", bdcdyid);
            bdcXmList = entityMapper.selectByExample(example);
        }
        return bdcXmList;
    }

    @Override
    public List<BdcXm> getCfXmByBdcdyh(String bdcdyh) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            bdcXmList = bdcXmMapper.getCfXmByBdcdyh(bdcdyh);
        }
        return bdcXmList;
    }

    @Override
    public BdcXm getBdcXmByBdcqzh(String bdcqzh) {
        BdcXm bdcXm = null;
        if (StringUtils.isNotBlank(bdcqzh)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcqzh", bdcqzh);
            List<BdcXm> bdcXmList = bdcXmMapper.getBdcXmByBdcZsMap(hashMap);
            if (CollectionUtils.isNotEmpty(bdcXmList)) {
                bdcXm = bdcXmList.get(0);
            }
        }
        return bdcXm;
    }

    @Override
    public Integer getBdcdyCountByWiid(String wiid) {
        return bdcXmMapper.getBdcdyCountByWiid(wiid);
    }

    @Override
    public String getDjsy(String proid) {
        //zhangyu   从新实现  按照新逻辑获取登记事由名称
        String djsymc = "";
        BdcXm bdcXm = getBdcXmByProid(proid);
        if (null != bdcXm) {
            String djsy = bdcXm.getDjsy();
            if (StringUtils.isNotBlank(djsy) && StringUtils.length(djsy) > 0 && djsy.indexOf("/") > -1) {
                djsymc = bdcZdGlService.getBdcZdDjsyMcByDm(djsy.substring(0, djsy.indexOf("/")));
            } else if (StringUtils.isNotBlank(djsy)) {
                djsymc = bdcZdGlService.getBdcZdDjsyMcByDm(djsy);
            }
        }


        return djsymc;

        //注释调  之前逻辑思路存在问题
        //return bdcXmMapper.getDjsy(proid);
    }

    @Override
    public BdcXm createBdcXm() {
        String proid = UUIDGenerator.generate18();
        String wiid = UUIDGenerator.generate18();
        BdcXm bdcXm = new BdcXm();
        bdcXm.setProid(proid);
        bdcXm.setWiid(wiid);
        UserInfo userInfo = SessionUtil.getCurrentUser();
        if (userInfo != null) {
            String userId = userInfo.getId();
            if (StringUtils.isNoneBlank(userId)) {
                bdcXm.setDwdm(PlatformUtil.getCurrentUserDwdmByUserid(userId));
                bdcXm.setCjr(PlatformUtil.getCurrentUserName(userId));
            }
        }
        bdcXm.setCjsj(new Date());
        bdcXm.setBh(bdcSlbhServiceContext.getSlbhService().generateBdcXmSlbh(bdcXm));
        bdcXm.setXmzt(Constants.XMZT_BJ);
        return bdcXm;
    }

    @Override
    public Boolean isHb(String proid) {
        Boolean isHb = false;
        int dyaqNumber = 0;
        int otherNumber = 0;
        String wiid = "";
        BdcXm bdcXm = getBdcXmByProid(proid);
        if (bdcXm != null) {
            wiid = bdcXm.getWiid();
        }
        List<BdcXm> bdcXmList = getBdcXmListByWiid(wiid);
        if (CollectionUtils.isNotEmpty(bdcXmList)) {
            for (BdcXm isHbXm : bdcXmList) {
                if (dyaqNumber > 0 && otherNumber > 0) {
                    isHb = true;
                    break;
                }
                String qllx = isHbXm.getQllx();
                if (StringUtils.equals(qllx, Constants.QLLX_DYAQ)) {
                    dyaqNumber += 1;
                } else if (!StringUtils.equals(isHbXm.getQllx(), Constants.QLLX_YGDJ)) {
                    otherNumber += 1;
                }
                //预告合并登记单独处理
                if (StringUtils.equals(isHbXm.getDjlx(), Constants.DJLX_HBDJ_DM) && StringUtils.equals(isHbXm.getQllx(), Constants.QLLX_YGDJ)) {
                    isHb = true;
                    break;
                }
            }
        }
        return isHb;
    }

    @Override
    public void saveBdcXm(BdcXm bdcXm) {
        //异常处理，增加判断当分别持证状态为null时，修改默认分别持证状态为“否”
        BdcXm currentBdcXm = getBdcXmByProid(bdcXm.getProid());
        if (null != currentBdcXm && currentBdcXm.getSqfbcz() == null) {
            bdcXm.setSqfbcz("否");
        }
        entityMapper.saveOrUpdate(bdcXm, bdcXm.getProid());
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 通过bdcdyid查询所有产生证书证明的项目
     **/
    @Override
    public List<String> listZsZmProidByBdcdyid(String bdcdyid) {
        return bdcXmMapper.listZsZmProidByBdcdyid(bdcdyid);
    }

    @Override
    public List<BdcXm> getBdcXmListByProid(String proid) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcXm.class);
            example.createCriteria().andEqualTo("proid", proid);
            bdcXmList = entityMapper.selectByExample(example);
        }
        return bdcXmList;
    }

    @Override
    public List<Map> getAllLxByWdid(String wdid) {
        return bdcXmMapper.getAllLxByWdid(wdid);
    }
//    @Override
//    public BdcXm creatBdcXm(Project project, BdcXm ybdcXm, String userName) {
//        BdcXm bdcxm = new BdcXm();
//        bdcxm.setProid(project.getProid());
//        bdcxm.setWiid(project.getWiid());
//        bdcxm.setDjlx(project.getDjlx());
//        bdcxm.setQllx(project.getQllx());
//        bdcxm.setSqlx(project.getSqlx());
//        bdcxm.setDjsy(project.getDjsy());
//        if (StringUtils.isNotBlank(project.getBdclx()))
//            bdcxm.setBdclx(project.getBdclx());
//        if (StringUtils.isNotBlank(ybdcXm.getBh()))
//            bdcxm.setBh(ybdcXm.getBh());
//        if (StringUtils.isNotBlank(ybdcXm.getBdclx()))
//            bdcxm.setBdclx(ybdcXm.getBdclx());
//        if (StringUtils.isNotBlank(userName))
//            bdcxm.setCjr(userName);
//        bdcxm.setCjsj(new Date());
//        bdcxm = getDydjlx(bdcxm);
//        entityMapper.saveOrUpdate(bdcxm, bdcxm.getProid());
//        return bdcxm;
//    }

    public BdcXm getDydjlx(BdcXm bdcxm) {
        if (StringUtils.isNotBlank(bdcxm.getSqlx())) {
            String dydjlx = "";
            if (CommonUtil.indexOfStrs(Constants.SQLX_DY_SCDJ, bdcxm.getSqlx())) {
                dydjlx = Constants.DJLX_CSDJ_DM;
            } else if (CommonUtil.indexOfStrs(Constants.SQLX_DY_ZYDJ, bdcxm.getSqlx())) {
                dydjlx = Constants.DJLX_ZYDJ_DM;
            } else if (CommonUtil.indexOfStrs(Constants.SQLX_DY_BGDJ, bdcxm.getSqlx())) {
                dydjlx = Constants.DJLX_BGDJ_DM;
            } else if (CommonUtil.indexOfStrs(Constants.SQLX_DY_ZXDJ, bdcxm.getSqlx())) {
                dydjlx = Constants.DJLX_ZXDJ_DM;
            }
            bdcxm.setDydjlx(dydjlx);
        }
        return bdcxm;
    }


    @Override
    public BdcXm creatBdcXm(final String proid, final String userName, final String wdid, final String wiid) {
        BdcXm bdcxm = new BdcXm();
        bdcxm.setProid(proid);
        String workFlowName = "";
        if (StringUtils.isNotBlank(wdid)) {
            workFlowName = PlatformUtil.getWdNameByWdid(wdid);
        } else {
            workFlowName = PlatformUtil.getWorkFlowNameByProid(proid);
        }
        if (StringUtils.isNotBlank(wdid)) {
            List<Map> mapList = getAllLxByWdid(wdid);
            if (mapList != null && mapList.size() > 0) {
                Map map = mapList.get(0);
                String djsy = "";
                if (map.get("QLLXDM") != null) {
                    bdcxm.setQllx(map.get("QLLXDM").toString());
                }
                if (map.get("SQLXDM") != null) {
                    bdcxm.setSqlx(map.get("SQLXDM").toString());
                    djsy = bdcSqlxDjsyRelService.getDjsyBySqlx(bdcxm.getSqlx());
                }
                if (map.get("DJLXDM") != null) {
                    bdcxm.setDjlx(map.get("DJLXDM").toString());
                }
                if (StringUtils.isNotBlank(djsy)) {
                    bdcxm.setDjsy(djsy);
                } else {
                    if (map.get("DJSYDM") != null) {
                        bdcxm.setDjsy(map.get("DJSYDM").toString());
                    }
                }
            } else {
                //zdd 无法根据申请类型对应权利类型的情况
                List<BdcZdSqlx> sqlxList = bdcZdGlService.getBdcZdSqlxList();
                if (sqlxList != null && sqlxList.size() > 0) {
                    String sqlxdm = "";
                    for (BdcZdSqlx sqlxmap : sqlxList) {
                        if (sqlxmap.getMc() != null && sqlxmap.getMc().equals(workFlowName)) {
                            if (StringUtils.isNotBlank(sqlxmap.getDm())) {
                                sqlxdm = sqlxmap.getDm();
                            }
                            break;
                        }
                    }
                    String djlxdm = "";
                    List<Map> djlxSqlxRelList = bdcZdGlService.getDjlxSqlxRel();
                    if (djlxSqlxRelList != null && djlxSqlxRelList.size() > 0) {
                        for (Map djlxSqlxMap : djlxSqlxRelList) {
                            if (djlxSqlxMap.containsKey("SQLXDM") && djlxSqlxMap.get("SQLXDM") != null && djlxSqlxMap.get("SQLXDM").equals(sqlxdm)) {
                                if (djlxSqlxMap.containsKey("DJLXDM") && djlxSqlxMap.get("DJLXDM") != null) {
                                    djlxdm = djlxSqlxMap.get("DJLXDM").toString();
                                }
                                break;
                            }
                        }
                    }
                    bdcxm.setSqlx(sqlxdm);
                    bdcxm.setDjlx(djlxdm);

                }
            }
            if (StringUtils.isNotBlank(userName)) {
                bdcxm.setCjr(userName);
            }
            bdcxm.setCjsj(new Date());
            PfWorkFlowInstanceVo pfWorkFlowInstanceVo = sysWorkFlowInstanceService.getWorkflowInstanceByProId(proid);
            if (StringUtils.isBlank(bdcxm.getBh())) {
                if (pfWorkFlowInstanceVo != null) {
                    bdcxm.setBh(pfWorkFlowInstanceVo.getWorkflowIntanceName());
                    bdcxm.setLzrq(CalendarUtil.addDays(pfWorkFlowInstanceVo.getTimeLimit()));
                }
            }
            //领证日期
            if (pfWorkFlowInstanceVo != null) {
                List<ActivityModel> activityModelList = PlatformUtil.getAllActivity(pfWorkFlowInstanceVo.getWorkflowIntanceId());
                //jyl 总时限减发证节点时限，自动生成领证日期。
                String timeLimit = pfWorkFlowInstanceVo.getTimeLimit();
                if (CollectionUtils.isNotEmpty(activityModelList)) {
                    int overDate = 0;
                    for (ActivityModel activityModel : activityModelList) {
                        //发证作为终止节点，所以可以这样写，否则不能
                        if (StringUtils.isNotBlank(timeLimit) && StringUtils.equals(activityModel.getActivityDefineName(), Constants.WORKFLOW_FZ)) {
                            overDate = Integer.parseInt(timeLimit) - Integer.parseInt(activityModel.getLimit());
                        }
                    }
                    if (overDate != 0) {
                        overDate = overDate + 1;
                    }
                    Date lzrq = sysCalendarService.getOverTime(new Date(), overDate + "");
                    if (lzrq != null) {
                        bdcxm.setLzrq(lzrq);
                    }
                }
            }
        }
        bdcxm = getDydjlx(bdcxm);
        if (StringUtils.isNotBlank(wiid)) {
            bdcxm.setWiid(wiid);
        }
        entityMapper.saveOrUpdate(bdcxm, bdcxm.getProid());
        return bdcxm;
    }

    @Override
    public void delBdcXmByProid(String proid) {
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcXm.class);
            example.createCriteria().andEqualTo("proid", proid);
            entityMapper.deleteByExample(BdcXm.class, example);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public List<BdcXm> andEqualQueryBdcXm(HashMap<String, String> map) {
        List<BdcXm> list = null;
        Example bdcxm = new Example(BdcXm.class);
        if (map != null && map.entrySet().size() > 0) {
            Iterator iter = map.entrySet().iterator();
            Example.Criteria criteria = bdcxm.createCriteria();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (val != null) {
                    if (StringUtils.equals(key.toString(), "order")) {
                        bdcxm.setOrderByClause(val.toString());
                    } else {
                        criteria.andEqualTo(key.toString(), val);
                    }
                }
            }
        }
        if (CollectionUtils.isNotEmpty(bdcxm.getOredCriteria()) && CollectionUtils.isNotEmpty(bdcxm.getOredCriteria().get(0).getAllCriteria())) {
            list = entityMapper.selectByExample(BdcXm.class, bdcxm);
        }

        return list;
    }

    @Override
    public List<BdcXm> getYbdcXmListByProid(String proid) {
        List<BdcXm> bdcXmList = null;
        if (StringUtils.isNotBlank(proid)) {
            List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByProid(proid);
            if (CollectionUtils.isNotEmpty(bdcXmRelList)) {
                bdcXmList = new ArrayList<BdcXm>();
                for (BdcXmRel bdcXmRel : bdcXmRelList) {
                    if (bdcXmRel != null && StringUtils.isNotBlank(bdcXmRel.getYproid())) {
                        BdcXm ybdcXm = getBdcXmByProid(bdcXmRel.getYproid());
                        if (ybdcXm != null) {
                            bdcXmList.add(ybdcXm);
                        }
                    }
                }
            }
        }

        return bdcXmList;
    }

    @Override
    @Transactional
    public void updateBdcXmRedundantField(BdcXm bdcXm) {
        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getProid())) {
            bdcXmMapper.updateBdcXmRedundantField(bdcXm);
        }
    }


    /**
     * @param taskInfo
     * @param project
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @rerutn Project 实体类数据
     * @description TaskInfo 实体类数据转到Project实体类
     */

    @Override
    public Project getProjectFromTaskInfo(TaskInfo taskInfo, Project project) {
        if (project == null) {
            project = new Project();
        }
        if (taskInfo != null) {

            if (CollectionUtils.isNotEmpty(taskInfo.getYbdcdyids())) {
                project.setYbdcdyids(taskInfo.getYbdcdyids());
            }
            if (CollectionUtils.isNotEmpty(taskInfo.getYxmids())) {
                project.setYxmids(taskInfo.getYxmids());
            }
            if (CollectionUtils.isNotEmpty(taskInfo.getDjIds())) {
                project.setDjIds(taskInfo.getDjIds());
            }
            if (CollectionUtils.isNotEmpty(taskInfo.getDcbIndexs())) {
                project.setDcbIndexs(taskInfo.getDcbIndexs());
            }
            if (CollectionUtils.isNotEmpty(taskInfo.getBdcdyhs())) {
                project.setBdcdyhs(taskInfo.getBdcdyhs());
            }


            if (StringUtils.isNotBlank(taskInfo.getGdproid())) {
                project.setGdproid(taskInfo.getGdproid());
            }
            if (StringUtils.isNotBlank(taskInfo.getTdids())) {
                project.setTdids(taskInfo.getTdids());
            }
            if (StringUtils.isNotBlank(taskInfo.getMsg())) {
                project.setMsg(taskInfo.getMsg());
            }
            if (StringUtils.isNotBlank(taskInfo.getWorkflowProid())) {
                project.setWorkflowProid(taskInfo.getWorkflowProid());
            }

            if (StringUtils.isNotBlank(taskInfo.getDjbid())) {
                project.setDjbid(taskInfo.getDjbid());
            }
            if (StringUtils.isNotBlank(taskInfo.getGdsyqid())) {
                project.setGdsyqid(taskInfo.getGdsyqid());
            }
            if (StringUtils.isNotBlank(taskInfo.getYbdcdyid())) {
                project.setYbdcdyid(taskInfo.getYbdcdyid());
            }
            if (StringUtils.isNotBlank(taskInfo.getYqlid())) {
                project.setYqlid(taskInfo.getYqlid());
            }

            if (StringUtils.isNotBlank(taskInfo.getDcbIndex())) {
                project.setDcbIndex(taskInfo.getDcbIndex());
            }
            if (StringUtils.isNotBlank(taskInfo.getDqjdmc())) {
                project.setDqjdmc(taskInfo.getDqjdmc());
            }
            if (StringUtils.isNotBlank(taskInfo.getZfjdmc())) {
                project.setZfjdmc(taskInfo.getZfjdmc());
            }
            if (StringUtils.isNotBlank(taskInfo.getGdid())) {
                project.setGdid(taskInfo.getGdid());
            }
            if (StringUtils.isNotBlank(taskInfo.getTaskid())) {
                project.setTaskid(taskInfo.getTaskid());
            }
            if (StringUtils.isNotBlank(taskInfo.getUserId())) {
                project.setUserId(taskInfo.getUserId());
            }
            if (StringUtils.isNotBlank(taskInfo.getBdcdyh())) {
                project.setBdcdyh(taskInfo.getBdcdyh());
            }
            if (StringUtils.isNotBlank(taskInfo.getZdzhh())) {
                project.setZdzhh(taskInfo.getZdzhh());
            }
            if (StringUtils.isNotBlank(taskInfo.getYxmid())) {
                project.setYxmid(taskInfo.getYxmid());
            }
            if (StringUtils.isNotBlank(taskInfo.getDjId())) {
                project.setDjId(taskInfo.getDjId());
            }
            if (StringUtils.isNotBlank(taskInfo.getWorkFlowDefId())) {
                project.setWorkFlowDefId(taskInfo.getWorkFlowDefId());
            }
            if (CollectionUtils.isNotEmpty(taskInfo.getBdcXmRelList())) {
                project.setBdcXmRelList(taskInfo.getBdcXmRelList());
            }
            if (StringUtils.isNotBlank(taskInfo.getYbdcqzh())) {
                project.setYbdcqzh(taskInfo.getYbdcqzh());
            }
            if (StringUtils.isNotBlank(taskInfo.getZl())) {
                project.setZl(taskInfo.getZl());
            }
            if (StringUtils.isNotBlank(taskInfo.getBdclx())) {
                project.setBdclx(taskInfo.getBdclx());
            }
            if (StringUtils.isNotBlank(taskInfo.getBh())) {
                project.setBh(taskInfo.getBh());
            }
            if (StringUtils.isNotBlank(taskInfo.getBz())) {
                project.setBz(taskInfo.getBz());
            }
            if (StringUtils.isNotBlank(taskInfo.getCjr())) {
                project.setCjr(taskInfo.getCjr());
            }
            if (StringUtils.isNotBlank(taskInfo.getDjlx())) {
                project.setDjlx(taskInfo.getDjlx());
            }
            if (taskInfo.getCjsj() != null) {
                project.setCjsj(taskInfo.getCjsj());
            }
            if (StringUtils.isNotBlank(taskInfo.getDjyy())) {
                project.setDjyy(taskInfo.getDjyy());
            }
            if (StringUtils.isNotBlank(taskInfo.getDwdm())) {
                project.setDwdm(taskInfo.getDwdm());
            }
            if (StringUtils.isNotBlank(taskInfo.getWiid())) {
                project.setWiid(taskInfo.getWiid());
            }
            if (StringUtils.isNotBlank(taskInfo.getProid())) {
                project.setProid(taskInfo.getProid());
            }
            if (StringUtils.isNotBlank(taskInfo.getXmly())) {
                project.setXmly(taskInfo.getXmly());
            }
            if (StringUtils.isNotBlank(taskInfo.getQllx())) {
                project.setQllx(taskInfo.getQllx());
            }
            if (StringUtils.isNotBlank(taskInfo.getBdcdyid())) {
                project.setBdcdyid(taskInfo.getBdcdyid());
            }
            if (StringUtils.isNotBlank(taskInfo.getSqlx())) {
                project.setSqlx(taskInfo.getSqlx());
            }
            if (StringUtils.isNotBlank(taskInfo.getDjsy())) {
                project.setDjsy(taskInfo.getDjsy());
            }
            if (taskInfo.getCjsj() != null) {
                project.setCjsj(taskInfo.getCjsj());
            } else {
                project.setCjsj(new Date());
            }
            if (StringUtils.isNotBlank(taskInfo.getXmly())) {
                project.setXmly(taskInfo.getXmly());
            }

            if (StringUtils.isNotBlank(taskInfo.getYbh())) {
                project.setYbh(taskInfo.getYbh());
            }
            if (StringUtils.isNotBlank(taskInfo.getDjzx())) {
                project.setDjzx(taskInfo.getDjzx());
            }
        }
        return project;
    }


    /**
     * @param taskInfo
     * @param project
     * @author <a href="mailto:zhangyu@gtmap.cn">zhangyu</a>
     * @rerutn TaskInfo
     * @description Project 实体类数据转到TaskInfo实体类
     */

    @Override
    public TaskInfo getTaskInfoFromProject(TaskInfo taskInfo, Project project) {
        if (taskInfo == null) {
            taskInfo = new TaskInfo();
        }
        if (project != null) {

            if (CollectionUtils.isNotEmpty(project.getYbdcdyids())) {
                taskInfo.setYbdcdyids(project.getYbdcdyids());
            }
            if (CollectionUtils.isNotEmpty(project.getYxmids())) {
                taskInfo.setYxmids(project.getYxmids());
            }
            if (CollectionUtils.isNotEmpty(project.getDjIds())) {
                taskInfo.setDjIds(project.getDjIds());
            }
            if (CollectionUtils.isNotEmpty(project.getDcbIndexs())) {
                taskInfo.setDcbIndexs(project.getDcbIndexs());
            }
            if (CollectionUtils.isNotEmpty(project.getBdcdyhs())) {
                taskInfo.setBdcdyhs(project.getBdcdyhs());
            }
            if (StringUtils.isNotBlank(project.getGdproid())) {
                taskInfo.setGdproid(project.getGdproid());
            }
            if (StringUtils.isNotBlank(project.getTdids())) {
                taskInfo.setTdids(project.getTdids());
            }
            if (StringUtils.isNotBlank(project.getMsg())) {
                taskInfo.setMsg(project.getMsg());
            }
            if (StringUtils.isNotBlank(project.getWorkflowProid())) {
                taskInfo.setWorkflowProid(project.getWorkflowProid());
            }

            if (StringUtils.isNotBlank(project.getDjbid())) {
                taskInfo.setDjbid(project.getDjbid());
            }
            if (StringUtils.isNotBlank(project.getGdsyqid())) {
                taskInfo.setGdsyqid(project.getGdsyqid());
            }
            if (StringUtils.isNotBlank(project.getYbdcdyid())) {
                taskInfo.setYbdcdyid(project.getYbdcdyid());
            }
            if (StringUtils.isNotBlank(project.getYqlid())) {
                taskInfo.setYqlid(project.getYqlid());
            }

            if (StringUtils.isNotBlank(project.getDcbIndex())) {
                taskInfo.setDcbIndex(project.getDcbIndex());
            }
            if (StringUtils.isNotBlank(project.getDqjdmc())) {
                taskInfo.setDqjdmc(project.getDqjdmc());
            }
            if (StringUtils.isNotBlank(project.getZfjdmc())) {
                taskInfo.setZfjdmc(project.getZfjdmc());
            }
            if (StringUtils.isNotBlank(project.getGdid())) {
                taskInfo.setGdid(project.getGdid());
            }
            if (StringUtils.isNotBlank(project.getTaskid())) {
                taskInfo.setTaskid(project.getTaskid());
            }
            if (StringUtils.isNotBlank(project.getUserId())) {
                taskInfo.setUserId(project.getUserId());
            }
            if (StringUtils.isNotBlank(project.getBdcdyh())) {
                taskInfo.setBdcdyh(project.getBdcdyh());
            }
            if (StringUtils.isNotBlank(project.getZdzhh())) {
                taskInfo.setZdzhh(project.getZdzhh());
            }
            if (StringUtils.isNotBlank(project.getYxmid())) {
                taskInfo.setYxmid(project.getYxmid());
            }
            if (StringUtils.isNotBlank(project.getDjId())) {
                taskInfo.setDjId(project.getDjId());
            }
            if (StringUtils.isNotBlank(project.getWorkFlowDefId())) {
                taskInfo.setWorkFlowDefId(project.getWorkFlowDefId());
            }
            if (CollectionUtils.isNotEmpty(project.getBdcXmRelList())) {
                taskInfo.setBdcXmRelList(project.getBdcXmRelList());
            }
            if (StringUtils.isNotBlank(project.getYbdcqzh())) {
                taskInfo.setYbdcqzh(project.getYbdcqzh());
            }
            if (StringUtils.isNotBlank(project.getZl())) {
                taskInfo.setZl(project.getZl());
            }
            if (StringUtils.isNotBlank(project.getBdclx())) {
                taskInfo.setBdclx(project.getBdclx());
            }
            if (StringUtils.isNotBlank(project.getBh())) {
                taskInfo.setBh(project.getBh());
            }
            if (StringUtils.isNotBlank(project.getBz())) {
                taskInfo.setBz(project.getBz());
            }
            if (StringUtils.isNotBlank(project.getCjr())) {
                taskInfo.setCjr(project.getCjr());
            }
            if (StringUtils.isNotBlank(project.getDjlx())) {
                taskInfo.setDjlx(project.getDjlx());
            }
            if (project.getCjsj() != null) {
                taskInfo.setCjsj(project.getCjsj());
            }
            if (StringUtils.isNotBlank(project.getDjyy())) {
                taskInfo.setDjyy(project.getDjyy());
            }
            if (StringUtils.isNotBlank(project.getDwdm())) {
                taskInfo.setDwdm(project.getDwdm());
            }
            if (StringUtils.isNotBlank(project.getWiid())) {
                taskInfo.setWiid(project.getWiid());
            }
            if (StringUtils.isNotBlank(project.getProid())) {
                taskInfo.setProid(project.getProid());
            }
            if (StringUtils.isNotBlank(project.getXmly())) {
                taskInfo.setXmly(project.getXmly());
            }
            if (StringUtils.isNotBlank(project.getQllx())) {
                taskInfo.setQllx(project.getQllx());
            }
            if (StringUtils.isNotBlank(project.getBdcdyid())) {
                taskInfo.setBdcdyid(project.getBdcdyid());
            }
            if (StringUtils.isNotBlank(project.getSqlx())) {
                taskInfo.setSqlx(project.getSqlx());
            }
            if (StringUtils.isNotBlank(project.getDjsy())) {
                taskInfo.setDjsy(project.getDjsy());
            }
            if (project.getCjsj() != null) {
                taskInfo.setCjsj(project.getCjsj());
            } else {
                taskInfo.setCjsj(new Date());
            }
            if (StringUtils.isNotBlank(project.getXmly())) {
                taskInfo.setXmly(project.getXmly());
            }

            if (StringUtils.isNotBlank(project.getYbh())) {
                taskInfo.setYbh(project.getYbh());
            }
            if (StringUtils.isNotBlank(project.getDjzx())) {
                taskInfo.setDjzx(project.getDjzx());
            }
        }
        return taskInfo;
    }

}
