package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXtConfigMapper;
import cn.gtmap.estateplat.config.core.service.BdcXtConfigService;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcXtConfigServiceImpl implements BdcXtConfigService {
    @Autowired
    BdcXtConfigMapper bdcXtConfigMapper;

    @Override
    public BdcXtConfig getBdcXtConfigByDwdm(String dwdm) {
        BdcXtConfig bdcXtConfig = null;
        if (StringUtils.isNotBlank(dwdm)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dwdm", dwdm);
            List<BdcXtConfig> bdcXtConfigList = bdcXtConfigMapper.getBdcXtConfigList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcXtConfigList))
                bdcXtConfig = bdcXtConfigList.get(0);
        }
        return bdcXtConfig;
    }

    @Override
    public BdcXtConfig queryBdczsBhConfig(final BdcXm bdcXm) {
        BdcXtConfig bdcXtConfig = null;
        HashMap<String, String> map = new HashMap<String, String>();
        if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getDwdm())) {
            map.put("dwdm", bdcXm.getDwdm());
            Calendar calendar = Calendar.getInstance();
            map.put("nf", String.valueOf(calendar.get(Calendar.YEAR)))  ;
            List<BdcXtConfig> bdcXtConfigList = bdcXtConfigMapper.getBdcXtConfigList(map);
            if(CollectionUtils.isNotEmpty(bdcXtConfigList))
                bdcXtConfig=bdcXtConfigList.get(0);
        }
        return bdcXtConfig;
    }

}
