package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXtYhMapper;
import cn.gtmap.estateplat.config.core.service.BdcXtYhService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.model.server.core.BdcXtYh;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * Created by Administrator on 2017/6/27.
 */
@Service
public class BdcXtYhServiceImpl implements BdcXtYhService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXtYhMapper bdcXtYhMapper;

    /**
     * 根据主键插入或更新银行配置.
     *
     * @param bdcBank 银行配置信息
     */
    @Override
    @Transactional
    public void insertOrUpdateByPrimaryKey(final BdcXtYh bdcBank) {
        if (bdcBank != null) {
            if (StringUtils.isBlank(bdcBank.getYhid())) {
                bdcBank.setYhid(UUIDGenerator.generate18());
            }
            entityMapper.saveOrUpdate(bdcBank, bdcBank.getYhid());
        }
    }

    /**
     * 根据主键删除银行配置.
     *
     * @param ids 主键，多个主键以逗号隔开
     * @return
     * @author liujie
     * @description 根据主键删除银行配置.
     */
    @Override
    @Transactional
    public void deleteBankByPrimaryKey(final String ids) {
        if (StringUtils.isBlank(ids))
            return;
        /**
         * 根据主键循环删除数据库记录
         */
        String[] id = ids.split(",");
        for (int i = 0; i < id.length; i++) {
            if (StringUtils.isNotBlank(id[i])) entityMapper.deleteByPrimaryKey(BdcXtYh.class, id[i]);
        }
    }

    @Override
    public List<HashMap> getBdcXtYhMapList() {
        return bdcXtYhMapper.getBdcXtYhMapList();
    }

    @Override
    public List<BdcXtYh> getBdcXtYhListByMap(HashMap hashMap) {
        return bdcXtYhMapper.getBdcXtYhListByMap(hashMap);
    }
}
