package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcYgMapper;
import cn.gtmap.estateplat.config.core.service.BdcYgService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcYg;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcYgServiceImpl implements BdcYgService {

    @Autowired
    BdcYgMapper bdcYgMapper;
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public List<BdcYg> getXsBdcYgList(String bdcdyh, String ygzl) {
        List<BdcYg> bdcYgList = null;
        if (StringUtils.isNotBlank(bdcdyh) || StringUtils.isNotBlank(ygzl)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcdyh", bdcdyh);
            hashMap.put("ygdjzl", ygzl);
            hashMap.put("qszt", Constants.QLLX_QSZT_XS.toString());
            bdcYgList = bdcYgMapper.getBdcYgListByBdcdy(hashMap);
        }
        return bdcYgList;
    }

    @Override
    public List<BdcYg> getBdcYgList(HashMap hashMap) {
        return bdcYgMapper.getBdcYgListByBdcdy(hashMap);
    }

    @Override
    public List<BdcYg> getBdcYgListByProid(String proid) {
        List<BdcYg> bdcYgList = null;
        if(StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcYg.class);
            example.createCriteria().andEqualTo("proid", proid);
            bdcYgList = entityMapper.selectByExample(example);
        }
        return bdcYgList;
    }

    @Override
    @Transactional
    public void updateBdcYgRedundantField(BdcYg bdcYg) {
        if(bdcYg != null&&StringUtils.isNotBlank(bdcYg.getQlid())) {
            bdcYgMapper.updateBdcYgRedundantField(bdcYg);
        }
    }
}
