package cn.gtmap.estateplat.config.core.service.impl;


import cn.gtmap.estateplat.config.core.mapper.config.BdcYyMapper;
import cn.gtmap.estateplat.config.core.service.BdcYyService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcYy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcYyServiceImpl implements BdcYyService {

    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private BdcYyMapper bdcYyMapper;

    @Override
    public BdcYy getBdcYyByProid(String proid) {
        BdcYy bdcYy = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcYy.class);
            example.createCriteria().andEqualTo("proid", proid);
            List<BdcYy> bdcYyList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcYyList))
                bdcYy = bdcYyList.get(0);
        }
        return bdcYy;
    }

    @Override
    @Transactional
    public void updateBdcYyRedundantField(BdcYy bdcYy) {
        if(bdcYy != null&&StringUtils.isNotBlank(bdcYy.getQlid())) {
            bdcYyMapper.updateBdcYyRedundantField(bdcYy);
        }
    }

    @Override
    public List<BdcYy> getBdcYyListByProid(String proid) {
        List<BdcYy> bdcYyList = null;
        if(StringUtils.isNotBlank(proid)) {
            Example example = new Example(BdcYy.class);
            example.createCriteria().andEqualTo("proid", proid);
            bdcYyList = entityMapper.selectByExample(example);
        }
        return bdcYyList;
    }
}
