package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcZdGlMapper;
import cn.gtmap.estateplat.config.core.service.BdcZdGlService;
import cn.gtmap.estateplat.config.core.service.TableService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/27.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcZdGlServiceImpl implements BdcZdGlService {
    @Autowired
    BdcZdGlMapper bdcZdGlMapper;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    TableService tableService;

    /**
     * @param hashMap
     * @author <a href="mailto:liubin@gtmap.cn">liubin</a>
     * @rerutn
     * @description 获取查封类型字典
     */
    @Override
    public List<HashMap> getBdcZdCflx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdCflx(hashMap);
    }

    @Override
    public List<BdcZdSqlx> getBdcZdSqlxList() {
        return bdcZdGlMapper.getBdcZdSqlxList(null);
    }

    @Override
    public List<BdcZdQllx> getBdcZdQllxList() {
        return bdcZdGlMapper.getBdcZdQllxList(null);
    }

    @Override
    public List<BdcZdCheck> getBdcZdCheckList() {
        return bdcZdGlMapper.getBdcZdCheckList(null);
    }

    @Override
    public List<BdcZdTables> getBdcZdTableList() {
        return bdcZdGlMapper.getBdcZdTableList(null);
    }

    @Override
    public List<HashMap> getFields(final String tableId) {
        List<HashMap> resultList = new ArrayList<HashMap>();
        //存储数据库表字段名
        List<String> validateDataList = new ArrayList<String>();
        //zwq 通过数据库表名获取表的所有字段名,将未被添加的字段名放入map中返回
        BdcZdTables bdcZdTables = entityMapper.selectByPrimaryKey(BdcZdTables.class, tableId);
        if (bdcZdTables != null) {
            if (StringUtils.isNotBlank(bdcZdTables.getTableId())) {
                if (StringUtils.equals("pf_usersign", bdcZdTables.getTableId())) {
                    validateDataList.add("SIGN_OPINION");
                } else {
                    //获取表字段名
                    validateDataList = tableService.getFiledName(bdcZdTables.getTableId().toUpperCase());
                }
            }
            if (CollectionUtils.isNotEmpty(validateDataList)) {
                for (int i = 0; i != validateDataList.size(); i++) {
                    HashMap map = new HashMap();
                    map.put("dm", validateDataList.get(i));
                    map.put("mc", validateDataList.get(i));
                    resultList.add(map);
                }
            }
        }
        return resultList;
    }

    @Override
    public List<BdcZdFwlx> getBdcZdFwlxList() {
        return bdcZdGlMapper.getBdcZdFwlxList(null);
    }


    @Override
    public List<BdcZdDjlx> getBdcZdDjlxList() {
        return bdcZdGlMapper.getBdcZdDjlxList(null);
    }

    @Override
    public List<Map> getBdcZdDzwtzmList() {
        return bdcZdGlMapper.getBdcZdDzwtzmList(null);
    }

    @Override
    public List<Map> getBdcZdQlxzList(Map<String, String> map) {
        return bdcZdGlMapper.getBdcZdQlxzList(map);
    }

    @Override
    public List<Map> getBdcZdQlxz(HashMap map) {
        return bdcZdGlMapper.getBdcZdQlxzList(map);
    }

    @Override
    public List<Map> getBdcZdDyfsList() {
        return bdcZdGlMapper.getBdcZdDyfsList(null);
    }

    @Override
    public List<Map> getBdcZdZdtzmList() {
        return bdcZdGlMapper.getBdcZdZdtzmList(null);
    }

    @Override
    public List<Map> getBdcZdBdclxList() {
        return bdcZdGlMapper.getBdcZdBdclxList(null);
    }

    @Override
    public List<BdcZdSqlx> getBdcZdSqlxByDjlx(String djlx) {
        List<BdcZdSqlx> bdcZdSqlxList = null;
        if (StringUtils.isNotBlank(djlx))
            bdcZdSqlxList = bdcZdGlMapper.getBdcZdSqlxByDjlx(djlx);
        return bdcZdSqlxList;
    }

    @Override
    public List<BdcZdZjlx> getBdcZdZjlxList() {
        return bdcZdGlMapper.getBdcZdZjlxList(null);
    }

    @Override
    public String getSqlxDmByWdid(String wdid) {
        String sqlxdm = null;
        if (StringUtils.isNotBlank(wdid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("wdid", wdid);
            List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlMapper.getBdcZdSqlxList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcZdSqlxList))
                sqlxdm = bdcZdSqlxList.get(0).getDm();
        }
        return sqlxdm;
    }

    @Override
    public String getWdidBySqlxDm(String sqlx) {
        String wdid = null;
        if (StringUtils.isNotBlank(sqlx)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dm", sqlx);
            List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlMapper.getBdcZdSqlxList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcZdSqlxList))
                wdid = bdcZdSqlxList.get(0).getWdid();
        }
        return wdid;
    }

    @Override
    public BdcZdQllx getBdcZdQllxByDm(String dm) {
        BdcZdQllx bdcZdQllx = null;
        if (StringUtils.isNotBlank(dm)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dm", dm);
            List<BdcZdQllx> bdcZdQllxList = bdcZdGlMapper.getBdcZdQllxList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcZdQllxList))
                bdcZdQllx = bdcZdQllxList.get(0);
        }
        return bdcZdQllx;
    }

    @Override
    public String getBdcZdMjdwDmByMc(String mc) {
        String dm = "";
        if (StringUtils.isNotBlank(mc)) {
            HashMap hashMap = new HashMap();
            hashMap.put("mc", mc);
            List<HashMap> hashMapList = bdcZdGlMapper.getBdcZdMjdwList(hashMap);
            if (CollectionUtils.isNotEmpty(hashMapList)) {
                dm = CommonUtil.formatEmptyValue(hashMapList.get(0).get("DM"));
            }
        }
        return dm;
    }

    @Override
    public String getBdcZdDjsyMcByDm(String dm) {
        String mc = "";
        if (StringUtils.isNotBlank(dm)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dm", dm);
            List<HashMap> hashMapList = bdcZdGlMapper.getBdcZdDjsyList(hashMap);
            if (CollectionUtils.isNotEmpty(hashMapList))
                mc = CommonUtil.formatEmptyValue(hashMapList.get(0).get("MC"));
        }
        return mc;
    }

    @Override
    public List<HashMap> getBdcZdDjsyList() {
        return bdcZdGlMapper.getBdcZdDjsyList(null);
    }

    @Override
    public List<BdcZdDjzx> getBdcZdDjzxList() {
        return bdcZdGlMapper.getBdcZdDjzxList(null);
    }

    @Override
    public HashMap getBdcZdDjsyByDm(String dm) {
        HashMap hashMap = null;
        if (StringUtils.isNotBlank(dm)) {
            HashMap param = new HashMap();
            param.put("dm", dm);
            List<HashMap> hashMapList = bdcZdGlMapper.getBdcZdDjsyList(param);
            if (CollectionUtils.isNotEmpty(hashMapList))
                hashMap = hashMapList.get(0);
        }
        return hashMap;
    }

    @Override
    public BdcZdDjlx getBdcZdDjlxBySqlx(String sqlx) {
        BdcZdDjlx bdcZdDjlx = null;
        if (StringUtils.isNotBlank(sqlx)) {
            List<BdcZdDjlx> bdcZdDjlxList = bdcZdGlMapper.getBdcZdDjlxBySqlx(sqlx);
            if (CollectionUtils.isNotEmpty(bdcZdDjlxList))
                bdcZdDjlx = bdcZdDjlxList.get(0);
        }
        return bdcZdDjlx;
    }

    @Override
    public List<HashMap> getBdcZdBdcdyFwlx() {
        return bdcZdGlMapper.getBdcZdBdcdyFwlxByMap(null);
    }

    @Override
    public BdcZdDjzx getBdcZdDjzxByDjzxdm(String djzxdm) {
        BdcZdDjzx bdcZdDjzx = null;
        if (StringUtils.isNotBlank(djzxdm)) {
            Example example = new Example(BdcZdDjzx.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("dm", djzxdm);
            List<BdcZdDjzx> bdcZdDjzxList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcZdDjzxList))
                bdcZdDjzx = bdcZdDjzxList.get(0);
        }
        return bdcZdDjzx;
    }

    @Override
    public List<BdcZdFy> getBdcZdFy() {
        return entityMapper.select(new BdcZdFy());
    }

    @Override
    public List<BdcZdQllx> getBdcZdQllxBySqlx(String sqlx) {
        List<BdcZdQllx> bdcZdQllxList = null;
        if (StringUtils.isNotBlank(sqlx)) {
            HashMap hashMap = new HashMap();
            hashMap.put("sqlxdm", sqlx);
            bdcZdQllxList = bdcZdGlMapper.getBdcZdQllxListByBdcSqlxQllxRel(hashMap);
        }
        return bdcZdQllxList;
    }

    @Override
    public List<BdcZdFwyt> getBdcZdFwyt() {
        return entityMapper.select(new BdcZdFwyt());
    }

    @Override
    public List<HashMap> getQlxzZdb(HashMap hashMap) {
        return bdcZdGlMapper.getQlxzZdb(hashMap);
    }

    @Override
    public List<Map> getBdcZdQlsdfsList() {
        return bdcZdGlMapper.getBdcZdQlsdfs(null);
    }

    @Override
    public List<Map> getBdcZdQlsdfs(HashMap map) {
        return bdcZdGlMapper.getBdcZdQlsdfs(map);
    }

    @Override
    public List<Map> getZdGyfs() {
        return bdcZdGlMapper.getZdGyfs();
    }


    /**
     * @param hashMap
     * @author <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @rerutn BdcZdQllx
     * @description 获取权利类型字典
     */
    @Override
    public List<BdcZdQllx> getBdcZdQllx(HashMap hashMap) {
        return bdcZdGlMapper.getbdcZdQllx(hashMap);
    }

    @Override
    public List<HashMap> getQlrxzList() {
        return bdcZdGlMapper.getQlrxzList();
    }

    @Override
    public List<HashMap> getQlrlxList() {
        return bdcZdGlMapper.getQlrlxList();
    }

    @Override
    public List<Map<String, String>> listBdcBdclxQllxRel(Map<String, Object> paramMap) {
        return bdcZdGlMapper.listBdcBdclxQllxRel(paramMap);
    }

    @Override
    public List<HashMap> getBdcZdDjlx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdDjlx(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdDybdclx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdDybdclx(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdGyfsByDm(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdGyfsByDm(hashMap);
    }

    @Override
    public String getGyfsByDm(String dm) {
        return bdcZdGlMapper.getGyfsByDm(dm);
    }

    @Override
    public List<HashMap> getBdcZdGzwlx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdGzwlx(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdzhyt(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdzhyt(hashMap);
    }

    @Override
    public List<HashMap> getBdcWjmhdyt(HashMap hashMap) {
        return bdcZdGlMapper.getBdcWjmhdyt(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdYhlx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdYhlx(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdYhlxb(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdYhlxb(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdHydb(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdHydb(hashMap);
    }

    @Override
    public List<Map> getDjlxByBdclx(String bdclxdm) {
        return bdcZdGlMapper.getDjlxByBdclx(bdclxdm);
    }

    @Override
    public List<Map> getSqlxByDjlx(String djlxdm) {
        return bdcZdGlMapper.getSqlxByDjlx(djlxdm);
    }

    @Override
    public String parseNameToCode(String name, String dictionaryName) {
        if (StringUtils.isNoneBlank(name, dictionaryName)) {
            Map<String, String> paramMap = Maps.newHashMap();
            paramMap.put("name", name);
            paramMap.put("dictionaryName", dictionaryName);
            String code = bdcZdGlMapper.parseNameToCode(paramMap);
            if (StringUtils.isNoneBlank(code)) {
                return code;
            }
        }
        return name;
    }

    @Override
    public String parseCodeToName(String code, String dictionaryName) {
        if (StringUtils.isNoneBlank(code, dictionaryName)) {
            Map<String, String> paramMap = Maps.newHashMap();
            paramMap.put("code", code);
            paramMap.put("dictionaryName", dictionaryName);
            String name = bdcZdGlMapper.parseCodeToName(paramMap);
            if (StringUtils.isNoneBlank(name)) {
                return name;
            }
        }
        return code;
    }

    @Override
    public List<HashMap> getBdcZdYhfs(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdYhfs(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdSyttlx(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdSyttlx(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdYzfs(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdYzfs(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdCbjyqqdfs(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdCbjyqqdfs(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdXmxz(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdXmxz(hashMap);
    }

    @Override
    public List<HashMap> getDjsjZdFwxz(HashMap hashMap) {
        return bdcZdGlMapper.getDjsjZdFwxz(hashMap);
    }

    @Override
    public List<HashMap> getDjsjZdFwjg(HashMap hashMap) {
        return bdcZdGlMapper.getDjsjZdFwjg(hashMap);
    }

    @Override
    public List<HashMap> getBdcZdLz(HashMap hashMap) {
        return bdcZdGlMapper.getBdcZdLz(hashMap);
    }

    @Override
    public List<HashMap> getDjsjZdLdqy(HashMap hashMap) {
        return bdcZdGlMapper.getDjsjZdLdqy(hashMap);
    }

    @Override
    public List<HashMap> getDjsjZdDldm(HashMap hashMap) {
        return bdcZdGlMapper.getDjsjZdDldm(hashMap);
    }

    @Override
    public String getSqlxMcByDm(String sqlxdm) {
        String sqlxmc = null;
        if (StringUtils.isNotBlank(sqlxdm)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dm", sqlxdm);
            List<BdcZdSqlx> bdcZdSqlxList = bdcZdGlMapper.getBdcZdSqlxList(hashMap);
            if (CollectionUtils.isNotEmpty(bdcZdSqlxList))
                sqlxmc = bdcZdSqlxList.get(0).getMc();
        }
        return sqlxmc;
    }
    @Override
    public String getBdcSqlxdmByWdid(final String wdid) {
        String sqlxdm = "";
        if (StringUtils.isNotBlank(wdid)) {
            HashMap map = Maps.newHashMap();
            map.put("wdid", wdid);
            List<BdcZdSqlx> bdcZdSqlxList = getBdcSqlxByMap(map);
            if (CollectionUtils.isNotEmpty(bdcZdSqlxList))
                sqlxdm = bdcZdSqlxList.get(0).getDm();
        }

        return sqlxdm;
    }

    @Override
    public List<BdcZdSqlx> getBdcSqlxByMap(HashMap hashMap) {
        return bdcZdGlMapper.getBdcSqlxByMap(hashMap);
    }
    @Override
    public List<Map> getDjlxSqlxRel() {

        return bdcZdGlMapper.getDjlxSqlxRel();
    }
}
