package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcXtZsQlqtzkMapper;
import cn.gtmap.estateplat.config.core.service.BdcQlrService;
import cn.gtmap.estateplat.config.core.service.BdcZsCreatZsInfoService;
import cn.gtmap.estateplat.config.utils.PublicUtil;
import cn.gtmap.estateplat.model.server.core.BdcDyZs;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcXtZsQlqtzk;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: lst
 * Date: 15-12-16
 * Time: 上午9:54
 * To change this template use File | Settings | File Templates.
 */
@Repository
public class BdcZsCreatZsInfoServiceImpl implements BdcZsCreatZsInfoService {

    @Autowired
    BdcXtZsQlqtzkMapper bdcXtZsQlqtzkMapper;
    @Autowired
    BdcQlrService bdcQlrService;

    @Override
    @Transactional(readOnly = true)
    public BdcDyZs setQygyr(BdcXm bdcXm, String czr, BdcDyZs bdcDyZs) {
        String qlqtzk = "";
        if (StringUtils.isNotBlank(bdcDyZs.getQlqtzk())) {
            qlqtzk = bdcDyZs.getQlqtzk();
        }
        StringBuffer qygyr = new StringBuffer();
        List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcXm.getProid());
        //共有方式按份共有中有共同共有
        if (bdcQlrService.isAfgyContainGtgy(bdcQlrList)) {
            BdcQlr bdcQlr = null;
            if (StringUtils.isNotBlank(czr)) {
                String[] qlrs = czr.split(" ");
                String qlrmc = qlrs[0];
                for (BdcQlr bdcQlrTemp : bdcQlrList) {
                    if (StringUtils.equals(bdcQlrTemp.getQlrmc(), qlrmc)) {
                        bdcQlr = bdcQlrTemp;
                        break;
                    }
                }
            }


            if (bdcQlr != null) {
                for (BdcQlr bdcQlrTemp : bdcQlrList) {
                    if (!StringUtils.equals(bdcQlr.getQlrmc(), bdcQlrTemp.getQlrmc()))
                        qygyr.append(bdcQlrTemp.getQlrmc()).append(" ");
                }
            }

        } else {
            List<BdcQlr> qlrList = bdcQlrService.queryBdcQlrByProid(bdcXm.getProid());
            if (qlrList != null && qlrList.size() > 1) {
                for (BdcQlr bdcQlr : qlrList) {
                    if (!StringUtils.equals(bdcQlr.getQlrmc(), czr)) {
                        qygyr.append(bdcQlr.getQlrmc()).append(" ");
                    }
                }
            } else {
                return bdcDyZs;
            }

        }

        HashMap mapxt = new HashMap();
//        mapxt.put("qllxdm",bdcXm.getQllx());
        List<BdcXtZsQlqtzk> bdcXtZsQlqtzkList = bdcXtZsQlqtzkMapper.getBdcXtZsQlqtzk(mapxt);
        if (CollectionUtils.isNotEmpty(bdcXtZsQlqtzkList)) {
            for (int i = 0; i < bdcXtZsQlqtzkList.size(); i++) {
                String qlqtzkTemp = bdcXtZsQlqtzkList.get(i).getQlqtzkmb();
                if (qlqtzkTemp.indexOf("qygyr") > -1) {
                    if (StringUtils.isNotBlank(qygyr)) {
                        qlqtzk = qlqtzkTemp.replace("qygyr", qygyr) + "\n" + qlqtzk;
                        break;
                    }
                }
            }
        }
        bdcDyZs.setQlqtzk(qlqtzk);
        return bdcDyZs;
    }

    @Override
    public BdcDyZs setCzr(BdcXm bdcXm, String czr, BdcDyZs bdcDyZs) {
        List<BdcQlr> bdcQlrList = bdcQlrService.queryBdcQlrByProid(bdcXm.getProid());
        //共有方式按份共有中有共同共有
        if (bdcQlrService.isAfgyContainGtgy(bdcQlrList)) {
            String[] qlrs = czr.split(" ");
            czr = qlrs[0];
        }

        String[] qlrs = czr.split("、");
        String qlqtzk = "";
        if (StringUtils.isNotBlank(bdcDyZs.getQlqtzk())) {
            qlqtzk = bdcDyZs.getQlqtzk();
        }
        if (StringUtils.isNotBlank(czr)) {
            HashMap mapxt = new HashMap();
            mapxt.put("qllxdm",bdcXm.getQllx());
            List<BdcXtZsQlqtzk> bdcXtZsQlqtzkList = bdcXtZsQlqtzkMapper.getBdcXtZsQlqtzk(mapxt);
            if (CollectionUtils.isNotEmpty(bdcXtZsQlqtzkList)) {
                for (int i = 0; i < bdcXtZsQlqtzkList.size(); i++) {
                    String qlqtzkTemp = bdcXtZsQlqtzkList.get(i).getQlqtzkmb();
                    if (StringUtils.isNotBlank(qlqtzkTemp) && qlqtzkTemp.indexOf("czr") > -1) {
                        if (StringUtils.isNotBlank(czr)) {
                            qlqtzk = qlqtzkTemp.replace("czr", czr) + "\n" + qlqtzk;
                        }
                    }
                    if (CollectionUtils.isNotEmpty(bdcQlrList) && StringUtils.isNotBlank(bdcQlrList.get(0).getGyfs()) && bdcQlrList.get(0).getGyfs().equals("2")) {
                        if (StringUtils.isNotBlank(qlqtzkTemp) && qlqtzkTemp.indexOf("gyfe") > -1) {
                            String gyfe = "";
                            for (int j = 0; j < qlrs.length; j++) {
                                for (BdcQlr bdcQlr : bdcQlrList) {
                                    if (StringUtils.equals(bdcQlr.getQlrmc(), qlrs[j]) && StringUtils.isNotBlank(bdcQlr.getQlbl())) {
                                        if (j == 0) {
                                            gyfe = PublicUtil.percentage(bdcQlr.getQlbl());
                                        } else {
                                            gyfe = gyfe + "、" + PublicUtil.percentage(bdcQlr.getQlbl());
                                        }
                                    }
                                }
                            }
                            qlqtzk = qlqtzk + qlqtzkTemp.replace("gyfe", gyfe);
                        }
                    }
                }
            }
        }
        bdcDyZs.setQlqtzk(qlqtzk);
        return bdcDyZs;
    }
}
