package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcZsQlrRelService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcQlr;
import cn.gtmap.estateplat.model.server.core.BdcXm;
import cn.gtmap.estateplat.model.server.core.BdcZs;
import cn.gtmap.estateplat.model.server.core.BdcZsQlrRel;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:zhaodongdong@gtmap.cn">zdd</a>
 * @version V1.0, 15-3-23
 */
@Service
public class BdcZsQlrRelServiceImpl implements BdcZsQlrRelService {
    @Autowired
    EntityMapper entityMapper;
    @Override
    public void delZsQlrRelByZsid(final String zsid) {
        if (StringUtils.isNotBlank(zsid)) {
            Example example = new Example(BdcZsQlrRel.class);
            example.createCriteria().andEqualTo("zsid", zsid);
            entityMapper.deleteByExample(BdcZsQlrRel.class, example);
        }
    }
    @Override
    public void delBdcZsQlrRelByQlrid(final String qlrid) {
        if (StringUtils.isNotBlank(qlrid)) {
            Example example = new Example(BdcZsQlrRel.class);
            example.createCriteria().andEqualTo("qlrid", qlrid);
            entityMapper.deleteByExample(BdcZsQlrRel.class, example);
        }
    }

    @Override
    public List<BdcZsQlrRel> creatBdcZsQlrRel(BdcXm bdcXm, List<BdcZs> bdcZsList, List<BdcQlr> bdcQlrList) {
        List<BdcZsQlrRel> bdcZsQlrRelList = new ArrayList<BdcZsQlrRel>();
        if (bdcZsList != null && bdcZsList.size() > 0 && bdcQlrList != null && bdcQlrList.size() > 0) {
            if (bdcXm != null && StringUtils.isNotBlank(bdcXm.getSqfbcz()) && bdcXm.getSqfbcz().equals(Constants.BDCXM_FBCZ)) {
                for (int i = 0; i < bdcQlrList.size(); i++) {
                    BdcQlr bdcQlr = bdcQlrList.get(i);
                    if (bdcZsList.size() > i) {
                        BdcZsQlrRel bdcZsQlrRel = new BdcZsQlrRel();
                        bdcZsQlrRel.setGxid(UUIDGenerator.generate18());
                        bdcZsQlrRel.setQlrid(bdcQlr.getQlrid());
                        //zdd 此处防止证书与权利人对照关系与持证人不符
                        if (bdcZsList.get(i).getCzr().equals(bdcQlr.getQlrmc())) {
                            bdcZsQlrRel.setZsid(bdcZsList.get(i).getZsid());
                        } else {
                            String zsid = "";
                            for (BdcZs bdcZs : bdcZsList) {
                                if (bdcZs.getCzr().equals(bdcQlr.getQlrmc())) {
                                    zsid = bdcZs.getZsid();
                                    break;
                                }
                            }
                            if (zsid != null) {
                                bdcZsQlrRel.setZsid(zsid);
                            } else {
                                bdcZsQlrRel.setZsid(bdcZsList.get(i).getZsid());
                            }
                        }
                        entityMapper.insertSelective(bdcZsQlrRel);
                        bdcZsQlrRelList.add(bdcZsQlrRel);
                    }
                }
            } else {
                //如果不是分别持证，认为项目默认是一本证书
                for (BdcQlr bdcQlr : bdcQlrList) {
                    BdcZsQlrRel bdcZsQlrRel = new BdcZsQlrRel();
                    bdcZsQlrRel.setGxid(UUIDGenerator.generate18());
                    bdcZsQlrRel.setQlrid(bdcQlr.getQlrid());
                    bdcZsQlrRel.setZsid(bdcZsList.get(0).getZsid());
                    entityMapper.insertSelective(bdcZsQlrRel);
                    bdcZsQlrRelList.add(bdcZsQlrRel);
                }
            }
        }
        return bdcZsQlrRelList;
    }

}
