package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.BdcdySdService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.BdcBdcdySd;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcdySdServiceImpl implements BdcdySdService {
    @Autowired
    EntityMapper entityMapper;

    @Override
    @Transactional(readOnly = true)
    public List<BdcBdcdySd> queryBdcdySdByBdcdyh(final String bdcdyh, String sdzt) {
        List<BdcBdcdySd> bdcBdcdySdList = new ArrayList<BdcBdcdySd>();
        if (StringUtils.isNotBlank(bdcdyh)) {
            Example example = new Example(BdcBdcdySd.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("bdcdyh", bdcdyh);
            if (StringUtils.isNotBlank(sdzt))
                criteria.andEqualTo("xzzt", sdzt);
            bdcBdcdySdList = entityMapper.selectByExample(BdcBdcdySd.class, example);
        }
        return bdcBdcdySdList;
    }
}
