package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.BdcdyMapper;
import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.AppConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class BdcdyServiceImpl implements BdcdyService {
    @Autowired
    private BdcdyMapper bdcdyMapper;
    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private DjsjService djsjService;
    @Autowired
    private BdcHyService bdcHyService;
    @Autowired
    private BdcTdService bdcTdService;
    @Autowired
    private BdcDjbService bdcDjbService;


    @Override
    public List<String> getCqqidByBdcdy(String bdcdyh) {
        List<String> cqqidList = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            cqqidList = bdcdyMapper.getCqqidByBdcdy(bdcdyh);
        }
        return cqqidList;
    }

    @Override
    public List<BdcBdcdy> getBdcdyByZdzhh(final String zdzhh, final String bdclx) {
        List<BdcBdcdy> bdcdyList = null;
        if (StringUtils.isNotBlank(zdzhh)) {
            Example example = new Example(BdcBdcdy.class);
            if (StringUtils.isNotBlank(bdclx)) {
                example.createCriteria().andLike("bdcdyh", zdzhh + "%").andEqualTo("bdclx", bdclx);
            }
            else {
                example.createCriteria().andLike("bdcdyh", zdzhh + "%");
            }
            bdcdyList = entityMapper.selectByExample(BdcBdcdy.class, example);
        }
        return bdcdyList;
    }

    @Override
    public BdcBdcdy getBdcdyByBdcdyh(String bdcdyh) {
        BdcBdcdy bdcdy = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            Example example = new Example(BdcBdcdy.class);
            example.createCriteria().andEqualTo("bdcdyh", bdcdyh);
            List<BdcBdcdy> bdcdyList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcdyList)) {
                bdcdy = bdcdyList.get(0);
            }
        }
        return bdcdy;
    }

    @Override
    @Transactional(readOnly = true)
    public String getZdBdcdyh(final String bdcdyh) {
        String zdBdcdyh = "";
        HashMap map = new HashMap<String, String>();
        if (StringUtils.isNotBlank(bdcdyh)) {
            map.put("djh", bdcdyh.substring(0, 19));
            //zwq 当bdclx非为TDFW时候通过djh只会找到一条数据
            List<DjsjBdcdy> djsjBdcdyList = djsjService.getDjsjBdcdyTdList(map);
            if (CollectionUtils.isNotEmpty(djsjBdcdyList)) {
                zdBdcdyh = djsjBdcdyList.get(0).getBdcdyh();
            }
        }
        return zdBdcdyh;
    }

    @Override
    @Transactional(readOnly = true)
    public BdcBdcdy queryBdcdyById(final String bdcdyid) {
        return StringUtils.isNotBlank(bdcdyid) ? entityMapper.selectByPrimaryKey(BdcBdcdy.class, bdcdyid) : null;
    }

    @Override
    public BdcBdcdy queryBdcBdcdyByProid(String proid) {
        return StringUtils.isNotBlank(proid) ? bdcdyMapper.getBdcdyByProid(proid) : null;
    }

    @Override
    public BdcBdcdy initBdcdy(String bdcdyh, String bdclx, String bdcdyFwlx, BdcBdcdjb bdcdjb) {
        BdcBdcdy bdcBdcdy = null;
        //zdd 如果不动产单元号为空  则不生成
        if (StringUtils.isNotBlank(bdcdyh)) {
            bdcBdcdy = new BdcBdcdy();
            bdcBdcdy.setBdcdyid(UUIDGenerator.generate18());
            if (bdcdjb != null && StringUtils.isNotBlank(bdcdjb.getDjbid())) {
                bdcBdcdy.setDjbid(bdcdjb.getDjbid());
            }
            bdcBdcdy.setBdclx(bdclx);
            bdcBdcdy.setBdcdyh(bdcdyh);
            bdcBdcdy.setBdcdyfwlx(bdcdyFwlx);
        }
        return bdcBdcdy;
    }

    @Override
    public BdcBdcdy initDjBdcdy(String djId, String bdcdyh, String bdclx, String bdcdyFwlx) {
        BdcBdcdy bdcBdcdy = null;
        if (StringUtils.isNoneBlank(bdcdyh) && StringUtils.length(bdcdyh) > 19) {
            String djh = StringUtils.substring(bdcdyh, 0, 19);
            InitVoFromParm initVoFromParm = djsjService.getDjxx(djId, bdcdyh, bdclx, bdcdyFwlx);
            bdcBdcdy = getBdcdyByBdcdyh(bdcdyh);
            if (bdcBdcdy == null && StringUtils.isNoneBlank(djh)) {
                BdcBdcdjb bdcBdcdjb = bdcDjbService.selectBdcdjb(djh);
                if (bdcBdcdjb == null) {
                    bdcBdcdjb = bdcDjbService.initBdcdjb(initVoFromParm, djh);
                    if (bdcBdcdjb != null && StringUtils.isNoneBlank(bdcBdcdjb.getDjbid())) {
                        entityMapper.saveOrUpdate(bdcBdcdjb, bdcBdcdjb.getDjbid());
                    }
                }
                bdcBdcdy = initBdcdy(bdcdyh, bdclx, bdcdyFwlx, bdcBdcdjb);
                if (bdcBdcdy != null && StringUtils.isNoneBlank(bdcBdcdy.getBdcdyid())) {
                    entityMapper.saveOrUpdate(bdcBdcdy, bdcBdcdy.getBdcdyid());
                }
            } else if (StringUtils.isNoneBlank(djh)) {
                BdcBdcdjb bdcBdcdjb = bdcDjbService.selectBdcdjb(djh);
                if (bdcBdcdjb == null) {
                    bdcBdcdjb = bdcDjbService.initBdcdjb(initVoFromParm, djh);
                }
                if (bdcBdcdy != null && bdcBdcdjb != null && StringUtils.isNoneBlank(bdcBdcdjb.getDjbid())) {
                    entityMapper.saveOrUpdate(bdcBdcdjb, bdcBdcdjb.getDjbid());
                    bdcBdcdy.setDjbid(bdcBdcdjb.getDjbid());
                    if (StringUtils.isNoneBlank(bdcBdcdy.getBdcdyid())) {
                        entityMapper.saveOrUpdate(bdcBdcdy, bdcBdcdy.getBdcdyid());
                    }
                }
            }
            if (StringUtils.indexOf(bdclx, Constants.BDCLX_HY) > -1) {
                DjsjZhxx djsjZhxx = initVoFromParm.getDjsjZhxx();
                if (djsjZhxx != null) {
                    BdcHy bdcHy = bdcHyService.selectBdcHy(djh);
                    if (bdcHy == null) {
                        bdcHy = bdcHyService.getBdcHyFromZhxx(djsjZhxx);
                    }
                    if (bdcHy != null && StringUtils.isNoneBlank(bdcHy.getHyid())) {
                        entityMapper.saveOrUpdate(bdcHy, bdcHy.getHyid());
                        Example example = new Example(BdcHyFlxx.class);
                        example.createCriteria().andEqualTo("hyid", bdcHy.getHyid());
                        List<BdcHyFlxx> bdcHyFlxxList = entityMapper.selectByExampleNotNull(example);
                        if (CollectionUtils.isEmpty(bdcHyFlxxList)) {
                            bdcHyFlxxList = bdcHyService.getHyflxxsFromBdcHy(bdcHy);
                            if (CollectionUtils.isNotEmpty(bdcHyFlxxList)) {
                                entityMapper.batchSaveSelective(bdcHyFlxxList);
                            }
                        }
                        example = new Example(BdcHyFlxx.class);
                        example.createCriteria().andEqualTo("hyid", bdcHy.getHyid());
                        List<BdcHyYhydzb> bdcHyYhydzbList = entityMapper.selectByExampleNotNull(example);
                        if (CollectionUtils.isEmpty(bdcHyYhydzbList)) {
                            bdcHyYhydzbList = bdcHyService.getYhydzbFromZhxx(djsjZhxx, bdcHy);
                            if (CollectionUtils.isNotEmpty(bdcHyYhydzbList)) {
                                entityMapper.batchSaveSelective(bdcHyYhydzbList);
                            }
                        }
                    }
                }
            } else {
                BdcTd bdcTd = bdcTdService.selectBdcTd(djh);
                if (bdcTd == null) {
                    bdcTd = bdcTdService.getBdcTdFromDjxx(initVoFromParm, djh);
                    if (bdcTd != null && StringUtils.isNoneBlank(bdcTd.getTdid())) {
                        entityMapper.saveOrUpdate(bdcTd, bdcTd.getTdid());
                    }
                }
            }
        }
        return bdcBdcdy;
    }

    @Override
    public Map<String, String> getDjsjBdcdy(String bdcdyh, String bdclx) {
        Map<String, String> resultMap = null;
        Map<String, Object> paramMap = Maps.newHashMap();
        paramMap.put("bdcdyh", bdcdyh);
        paramMap.put("bdclx", bdclx);
        List<Map<String, String>> resultList = djsjService.getDjBdcdyListByPage(paramMap);
        if (CollectionUtils.isNotEmpty(resultList)) {
            resultMap = resultList.get(0);
        }
        return resultMap;
    }

    @Override
    @Transactional(readOnly = true)
    public List<String> queryBdcdyhByDah(final Map map) {
        return bdcdyMapper.queryBdcdyhByDah(map);
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:juyulin@gtmap.cn">juyulin</a>
     * @description 找出该流程所有不动产单元
     **/
    @Override
    public List<BdcBdcdy> listBdcBdcdy(final String wiid){
        return bdcdyMapper.listBdcBdcdy(wiid);
    }


    @Override
    @Transactional(readOnly = true)
    public String[] getDjQlrIdsByQlr(final String qlr,final String bdclx) {
        List<String> idList = new ArrayList<String>();
        String[] ids = null;
        if (StringUtils.isNotBlank(qlr)) {
            HashMap map = new HashMap();
            map.put("qlr", qlr);
            map.put("bdclx", bdclx);
            List<Map> djQlrList = djsjService.getDjQlrList(map);
            if (djQlrList != null && djQlrList.size() > 0) {
                for (Map qlrMap : djQlrList) {
                    if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(qlrMap.get("ID"))) && !idList.contains(CommonUtil.formatEmptyValue(qlrMap.get("ID")))) {
                        idList.add(CommonUtil.formatEmptyValue(qlrMap.get("ID")));
                    }
                }
            }
        }
        if (idList != null && idList.size() > 0) {
            ids = new String[idList.size()];
            int i = 0;
            for (String id : idList) {
                ids[i] = id;
                i++;
            }
        }
        return ids;
    }

    @Override
    @Transactional(readOnly = true)
    public String getDjQlrByDjid(final String djid,String bdclxdm,final String zdtzm, String wfsqlxdm) {
        String qlr = "";
        HashMap dyhMap = new HashMap();
        dyhMap.put("id", djid);
        if (StringUtils.isNotBlank(bdclxdm)) {
            if (StringUtils.equals(bdclxdm, Constants.DZWTZM_F)) {
                bdclxdm = Constants.BDCLX_TDFW;
            } else if (StringUtils.equals(bdclxdm, "W")) {
                if (StringUtils.isNotBlank(zdtzm) && zdtzm.indexOf("H") > -1) {
                    bdclxdm = Constants.BDCLX_HY;
                } else {
                    bdclxdm = Constants.BDCLX_TD;
                }

            } else if (StringUtils.equals(bdclxdm, "L")) {
                bdclxdm = Constants.BDCLX_TDSL;
            }
            else if (StringUtils.equals(bdclxdm, "Q")) {
                if (CommonUtil.indexOfStrs(Constants.SQLXDM_GZW, wfsqlxdm)) {
                    bdclxdm = Constants.BDCLX_TDGZW;
                } else {
                    bdclxdm = Constants.BDCLX_TDQT;
                }
            }
        }
        dyhMap.put("bdclx", bdclxdm);
        List<Map<String, String>> bdcdyMapList = djsjService.getDjBdcdyListByPage(dyhMap);
        HashMap map = new HashMap();
        map.put("djid", djid);
        map.put("bdclx", bdclxdm);
        if (bdcdyMapList != null && bdcdyMapList.size() > 0 && StringUtils.isNotBlank(CommonUtil.formatEmptyValue(bdcdyMapList.get(0).get("DJH")))) {
            map.put("djh", CommonUtil.formatEmptyValue(bdcdyMapList.get(0).get("DJH")));
        }
        List<Map> djQlrList = djsjService.getDjQlrList(map);
        if (djQlrList != null && djQlrList.size() > 0) {
            for (Map qlrMap : djQlrList) {
                if (StringUtils.isBlank(qlr)) {
                    qlr = CommonUtil.formatEmptyValue(qlrMap.get("QLR"));
                }
                else {
                    qlr = qlr + "/" + CommonUtil.formatEmptyValue(qlrMap.get("QLR"));
                }
            }
        }
        return qlr;
    }

    @Override
    @Transactional
    public void delBdcdyById(final String bdcdyid) {
        if (StringUtils.isNotBlank(bdcdyid)) {
            entityMapper.deleteByPrimaryKey(BdcBdcdy.class, bdcdyid);
        }
    }

    @Override
    public Integer getMaxBdcdyhLsh(Map map){
        return bdcdyMapper.getMaxBdcdyhLsh(map);
    }

    @Override
    @Transactional(readOnly = true)
    public String[] getDjidsByQlr(final String bdclx, final String qlrmc, final String qlrzjh) {
        List<String> idList = new ArrayList<String>();
        String[] ids = null;
        HashMap paramMap = new HashMap();
        paramMap.put("bdclx", bdclx);
        paramMap.put("qlr", qlrmc);
        paramMap.put("qlrzjh", qlrzjh);
        List<Map> djQlrList = djsjService.getDjQlrList(paramMap);
        if (djQlrList != null && djQlrList.size() > 0) {
            for (int i = 0; i < djQlrList.size(); i++) {
                Map qlrMap = djQlrList.get(i);
                if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(qlrMap.get("ID"))) && !idList.contains(CommonUtil.formatEmptyValue(qlrMap.get("ID")))) {
                    idList.add(CommonUtil.formatEmptyValue(qlrMap.get("ID")));
                }
            }
        }
        if (idList != null && idList.size() > 0) {
            ids = new String[idList.size()];
            int i = 0;
            for (String id : idList) {
                ids[i] = id;
                i++;
            }
        }
        return ids;
    }

}
