package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.*;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
 * @version 1.0, 2017/8/31
 * @description
 */
@Service
public class DataManagerServiceImpl implements DataManagerService {

    @Autowired
    private EntityMapper entityMapper;
    @Autowired
    private BdcXmService bdcXmService;
    @Autowired
    private BdcdyService bdcdyService;
    @Autowired
    private QllxService qllxService;
    @Autowired
    private BdcZsService bdcZsService;
    @Autowired
    private BdcQlrService bdcQlrService;
    @Autowired
    private BdcSpxxService bdcSpxxService;
    @Autowired
    private LogService logService;
    @Autowired
    private DjsjService djsjService;

    @Override
    public String addData(String djId, String bdcdyh, String qllx, String bdclx, String bdcdyFwlx) {
        String result = "success";
        String proid = StringUtils.EMPTY;
        try {
            BdcXm bdcXm = bdcXmService.createBdcXm();
            if (bdcXm != null && StringUtils.isNoneBlank(bdcXm.getProid())) {
                proid = bdcXm.getProid();
                String bdcdyid = StringUtils.EMPTY;
                bdcXm.setBdclx(StringUtils.isNotBlank(bdclx) ? bdclx : StringUtils.EMPTY);
                if (StringUtils.isNotBlank(bdcdyh)) {
                    BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
                    if (bdcBdcdy != null) {
                        bdcdyid = bdcBdcdy.getBdcdyid();
                        bdcXm.setBdcdyid(bdcBdcdy.getBdcdyid());
                    }
                } else {
                    bdcdyid = UUIDGenerator.generate18();
                    bdcXm.setBdcdyid(bdcdyid);
                }
                if (StringUtils.isNoneBlank(qllx)) {
                    bdcXm.setQllx(qllx);
                    InitVoFromParm initVoFromParm = djsjService.getDjxx(djId, bdcdyh, bdclx, bdcdyFwlx);
                    QllxVo qllxVo = qllxService.newQllxVo(bdcXm, bdcdyid, initVoFromParm);
                    if (qllxVo != null && StringUtils.isNoneBlank(qllxVo.getQlid())) {
                        logService.saveOrUpdateLog(qllxVo);
                        entityMapper.saveOrUpdate(qllxVo, qllxVo.getQlid());
                    }
                }
                BdcSpxx bdcSpxx = newBdcSpxx(proid, bdcdyh, bdclx);
                addBdcXmBdcSpxxParam(bdclx, qllx, bdcdyh, bdcXm, bdcSpxx);
                if (StringUtils.isNoneBlank(proid)) {
                    logService.saveOrUpdateLog(bdcXm);
                    entityMapper.saveOrUpdate(bdcXm, bdcXm.getProid());
                }
                if (bdcSpxx != null && StringUtils.isNoneBlank(bdcSpxx.getSpxxid())) {
                    logService.saveOrUpdateLog(bdcSpxx);
                    entityMapper.saveOrUpdate(bdcSpxx, bdcSpxx.getSpxxid());
                }
                BdcXmRel bdcXmRel = newBdcXmRel(proid, djId, qllx, bdcdyh, bdclx);
                if (bdcXmRel != null && StringUtils.isNoneBlank(bdcXmRel.getRelid())) {
                    logService.saveOrUpdateLog(bdcXmRel);
                    entityMapper.saveOrUpdate(bdcXmRel, bdcXmRel.getRelid());
                }
                BdcZs bdcZs = newBdcZs(qllx);
                if (bdcZs != null && StringUtils.isNoneBlank(bdcZs.getZsid())) {
                    bdcZs.setDwdm(bdcXm.getDwdm());
                    bdcZs.setNf(bdcXm.getNf());
                    logService.saveOrUpdateLog(bdcZs);
                    entityMapper.saveOrUpdate(bdcZs, bdcZs.getZsid());
                    BdcXmzsRel bdcXmzsRel = newBdcXmzsRel(bdcZs.getZsid(), proid);
                    if (bdcXmzsRel != null && StringUtils.isNoneBlank(bdcXmzsRel.getXmzsgxid())) {
                        logService.saveOrUpdateLog(bdcXmzsRel);
                        entityMapper.saveOrUpdate(bdcXmzsRel, bdcXmzsRel.getXmzsgxid());
                    }
                }
            }
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        return proid;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建关系表
     */
    private BdcXmRel newBdcXmRel(String proid, String djId, String qllx, String bdcdyh, String bdclx) {
        BdcXmRel bdcXmRel = new BdcXmRel();
        bdcXmRel.setRelid(UUIDGenerator.generate18());
        bdcXmRel.setProid(proid);
        bdcXmRel.setQjid(StringUtils.isNotBlank(djId) ? djId : StringUtils.EMPTY);
        bdcXmRel.setYdjxmly(Constants.XMLY_BDC);
        if (StringUtils.equals(qllx, Constants.QLLX_DYAQ) || StringUtils.equals(qllx, Constants.QLLX_CFDJ)) {
            //海域所有权、林权、草权
            if (StringUtils.isNotBlank(bdcdyh)) {
                BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
                if (bdcBdcdy != null && StringUtils.isNotBlank(bdcBdcdy.getBdcdyid())) {
                    if (StringUtils.contains(bdclx, Constants.BDCLX_HY)) {
                        Example example = new Example(BdcHysyq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcHysyq> bdcHysyqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcHysyqList)) {
                            QllxVo qllxVo = bdcHysyqList.get(0);
                            bdcXmRel = addBdcXmRelParam(bdcXmRel, qllxVo);
                            addBdcQlrParam(qllx, qllxVo, proid);
                        }
                    } else if (StringUtils.equals(bdclx, Constants.BDCLX_LQ)) {
                        Example example = new Example(BdcLq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcLq> bdcLqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcLqList)) {
                            QllxVo qllxVo = bdcLqList.get(0);
                            bdcXmRel = addBdcXmRelParam(bdcXmRel, qllxVo);
                            addBdcQlrParam(qllx, qllxVo, proid);
                        }
                    } else if (StringUtils.equals(bdclx, Constants.BDCLX_TDQT)) {
                        Example example = new Example(BdcTdcbnydsyq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcTdcbnydsyq> bdcTdcbnydsyqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcTdcbnydsyqList)) {
                            QllxVo qllxVo = bdcTdcbnydsyqList.get(0);
                            bdcXmRel = addBdcXmRelParam(bdcXmRel, qllxVo);
                            addBdcQlrParam(qllx, qllxVo, proid);
                        }
                    }
                }
            }
        }
        return bdcXmRel;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建审批信息表
     */
    private BdcSpxx newBdcSpxx(String proid, String bdcdyh, String bdclx) {
        BdcSpxx bdcSpxx = new BdcSpxx();
        bdcSpxx.setSpxxid(UUIDGenerator.generate18());
        bdcSpxx.setProid(proid);
        bdcSpxx.setBdcdyh(StringUtils.isNotBlank(bdcdyh) ? bdcdyh : StringUtils.EMPTY);
        bdcSpxx.setBdclx(StringUtils.isNotBlank(bdclx) ? bdclx : StringUtils.EMPTY);
        return bdcSpxx;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建证书表
     */
    private BdcZs newBdcZs(String qllx) {
        BdcZs bdcZs = null;
        if (!StringUtils.equals(qllx, Constants.QLLX_CFDJ)) {
            bdcZs = new BdcZs();
            bdcZs.setZsid(UUIDGenerator.generate18());
            if (!StringUtils.equals(qllx, Constants.QLLX_DYAQ)) {
                bdcZs.setZstype(Constants.BDCQZS_BH_FONT);
                bdcZs.setZslx(Constants.BDCQZS_BH_DM);
            } else {
                bdcZs.setZstype(Constants.BDCQZM_BH_FONT);
                bdcZs.setZslx(Constants.BDCQZM_BH_DM);
            }
            bdcZs.setQllx(qllx);
        }
        return bdcZs;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 新建项目证书关系表
     */
    public BdcXmzsRel newBdcXmzsRel(String zsid, String proid) {
        BdcXmzsRel bdcXmzsRel = null;
        if (StringUtils.isNoneBlank(zsid, proid)) {
            bdcXmzsRel = new BdcXmzsRel();
            bdcXmzsRel.setXmzsgxid(UUIDGenerator.generate18());
            bdcXmzsRel.setProid(proid);
            bdcXmzsRel.setZsid(zsid);
        }
        return bdcXmzsRel;
    }


    @Override
    public String delData(String proid) {
        String result = "success";
        try {
            BdcXm bdcXm = entityMapper.selectByPrimaryKey(BdcXm.class, proid);
            if (bdcXm != null) {
                delBdcQl(bdcXm);
            }
            delBdcQlr(proid);
            delBdcZs(proid);
            delBdcSpxx(proid);
            delBdcXmRel(proid);
            delBdcXm(proid);
        } catch (Exception e) {
            result = "fail";
            e.printStackTrace();
        }
        return result;
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除权利信息
     */
    private void delBdcQl(BdcXm bdcXm) {
        if (bdcXm != null) {
            QllxVo qllxVo = qllxService.makeSureQllx(bdcXm);
            if (qllxVo != null) {
                Example example = new Example(qllxVo.getClass());
                example.createCriteria().andEqualTo("proid", bdcXm.getProid());
                deleteByExample(example);
            }
        }
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除证书信息
     */
    private void delBdcZs(String proid) {
        List<BdcZs> bdcZsList = bdcZsService.getBdcZsByProid(proid);
        if (CollectionUtils.isNotEmpty(bdcZsList)) {
            for (BdcZs bdcZs : bdcZsList) {
                if (bdcZs != null && StringUtils.isNoneBlank(bdcZs.getZsid())) {
                    String zsid = bdcZs.getZsid();
                    Example example = new Example(BdcZs.class);
                    example.createCriteria().andEqualTo("zsid", zsid);
                    deleteByExample(example);
                    example = new Example(BdcZsQlrRel.class);
                    example.createCriteria().andEqualTo("zsid", zsid);
                    deleteByExample(example);
                    example = new Example(BdcXmzsRel.class);
                    example.createCriteria().andEqualTo("zsid", zsid);
                    deleteByExample(example);
                }
            }
        }
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除权利人信息
     */
    private void delBdcQlr(String proid) {
        if (StringUtils.isNoneBlank(proid)) {
            Example example = new Example(BdcQlr.class);
            example.createCriteria().andEqualTo("proid", proid);
            deleteByExample(example);
        }
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除不动产项目
     */
    private void delBdcXm(String proid) {
        if (StringUtils.isNoneBlank(proid)) {
            Example example = new Example(BdcXm.class);
            example.createCriteria().andEqualTo("proid", proid);
            deleteByExample(example);
        }
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除关系表
     */
    private void delBdcXmRel(String proid) {
        if (StringUtils.isNoneBlank(proid)) {
            Example example = new Example(BdcXmRel.class);
            example.createCriteria().andEqualTo("proid", proid);
            deleteByExample(example);
        }
    }

    /**
     * @author <a href="mailto:yulei1@gtmap.cn">yulei</a>
     * @description 删除审批信息
     */
    private void delBdcSpxx(String proid) {
        if (StringUtils.isNoneBlank(proid)) {
            Example example = new Example(BdcSpxx.class);
            example.createCriteria().andEqualTo("proid", proid);
            deleteByExample(example);
        }
    }

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description xm_rel的yproid、yqlid赋值
     */
    private BdcXmRel addBdcXmRelParam(BdcXmRel bdcXmRel, QllxVo qllxVo) {
        if (qllxVo instanceof BdcHysyq) {
            Example example = new Example(BdcHysyq.class);
            example.createCriteria().andEqualTo("bdcdyid", qllxVo.getBdcdyid()).andEqualTo("qszt", 1);
            List<BdcHysyq> bdcHysyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcHysyqList)) {
                BdcHysyq bdcHysyq = bdcHysyqList.get(0);
                if (StringUtils.isNotBlank(bdcHysyq.getProid())) {
                    bdcXmRel.setYproid(bdcHysyq.getProid());
//                    bdcXmRel.setYqlid(bdcHysyq.getQlid());
                }
            }
        } else if (qllxVo instanceof BdcLq) {
            Example example = new Example(BdcLq.class);
            example.createCriteria().andEqualTo("bdcdyid", qllxVo.getBdcdyid()).andEqualTo("qszt", 1);
            List<BdcLq> bdcLqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcLqList)) {
                BdcLq bdcLq = bdcLqList.get(0);
                if (StringUtils.isNotBlank(bdcLq.getProid())) {
                    bdcXmRel.setYproid(bdcLq.getProid());
//                    bdcXmRel.setYqlid(bdcLq.getQlid());
                }
            }
        } else if (qllxVo instanceof BdcTdcbnydsyq) {
            Example example = new Example(BdcTdcbnydsyq.class);
            example.createCriteria().andEqualTo("bdcdyid", qllxVo.getBdcdyid()).andEqualTo("qszt", 1);
            List<BdcTdcbnydsyq> bdcTdcbnydsyqList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(bdcTdcbnydsyqList)) {
                BdcTdcbnydsyq bdcTdcbnydsyq = bdcTdcbnydsyqList.get(0);
                if (StringUtils.isNotBlank(bdcTdcbnydsyq.getProid())) {
                    bdcXmRel.setYproid(bdcTdcbnydsyq.getProid());
//                    bdcXmRel.setYqlid(bdcTdcbnydsyq.getQlid());
                }
            }
        }
        return bdcXmRel;
    }

    public void deleteByExample(Example example) {
        if (CollectionUtils.isNotEmpty(entityMapper.selectByExampleNotNull(example))) {
            logService.deleteLog(entityMapper.selectByExampleNotNull(example).toArray());
            entityMapper.deleteByExampleNotNull(example);
        }
    }

    /**
     * @param
     * @author <a href="mailto:lizhi@gtmap.cn">lizhi</a>
     * @rerutn
     * @description 抵押查封带入原权利的权利人
     */
    private void addBdcQlrParam(String qllx, QllxVo qllxVo, String proid) {
        if (StringUtils.equals(qllx, Constants.QLLX_DYAQ)) {
            if (StringUtils.isNotBlank(qllxVo.getProid())) {
                List<BdcQlr> ybdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(qllxVo.getProid(), Constants.QLRLX_QLR);
                if (CollectionUtils.isNotEmpty(ybdcQlrList)) {
                    for (BdcQlr bdcQlr : ybdcQlrList) {
                        bdcQlr.setQlrid(UUIDGenerator.generate18());
                        bdcQlr.setProid(proid);
                        bdcQlr.setQlrlx(Constants.QLRLX_YWR);
                        logService.saveOrUpdateLog(bdcQlr);
                        entityMapper.saveOrUpdate(bdcQlr, bdcQlr.getQlrid());
                    }
                }
            }
        } else if (StringUtils.equals(qllx, Constants.QLLX_CFDJ)) {
            List<BdcQlr> ybdcQlrList = bdcQlrService.getBdcQlrListByProidAndQlrlx(qllxVo.getProid(), Constants.QLRLX_QLR);
            if (CollectionUtils.isNotEmpty(ybdcQlrList)) {
                for (BdcQlr bdcQlr : ybdcQlrList) {
                    bdcQlr.setQlrid(UUIDGenerator.generate18());
                    bdcQlr.setProid(proid);
                    bdcQlr.setQlrlx(Constants.QLRLX_QLR);
                    logService.saveOrUpdateLog(bdcQlr);
                    entityMapper.saveOrUpdate(bdcQlr, bdcQlr.getQlrid());
                }
            }
        }
    }

    private void addBdcXmBdcSpxxParam(String bdclx, String qllx, String bdcdyh, BdcXm bdcXm, BdcSpxx bdcSpxx) {
        String cqProid = StringUtils.EMPTY;
        if (StringUtils.equals(qllx, Constants.QLLX_DYAQ) || StringUtils.equals(qllx, Constants.QLLX_CFDJ)) {
            if (StringUtils.isNotBlank(bdcdyh)) {
                BdcBdcdy bdcBdcdy = bdcdyService.getBdcdyByBdcdyh(bdcdyh);
                if (bdcBdcdy != null && StringUtils.isNotBlank(bdcBdcdy.getBdcdyid())) {
                    if (StringUtils.contains(bdclx, Constants.BDCLX_HY)) {
                        Example example = new Example(BdcHysyq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcHysyq> bdcHysyqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcHysyqList)) {
                            QllxVo qllxVo = bdcHysyqList.get(0);
                            cqProid = qllxVo.getProid();
                        }
                    } else if (StringUtils.equals(bdclx, Constants.BDCLX_LQ)) {
                        Example example = new Example(BdcLq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcLq> bdcLqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcLqList)) {
                            QllxVo qllxVo = bdcLqList.get(0);
                            cqProid = qllxVo.getProid();
                        }
                    } else if (StringUtils.equals(bdclx, Constants.BDCLX_TDQT)) {
                        Example example = new Example(BdcTdcbnydsyq.class);
                        example.createCriteria().andEqualTo("bdcdyid", bdcBdcdy.getBdcdyid()).andEqualTo("qszt", 1);
                        List<BdcTdcbnydsyq> bdcTdcbnydsyqList = entityMapper.selectByExample(example);
                        if (CollectionUtils.isNotEmpty(bdcTdcbnydsyqList)) {
                            QllxVo qllxVo = bdcTdcbnydsyqList.get(0);
                            cqProid = qllxVo.getProid();
                        }
                    }
                }
                if (StringUtils.isNoneBlank(cqProid)) {
                    BdcXm cqXm = bdcXmService.getBdcXmByProid(cqProid);
                    if (cqXm != null && bdcXm != null) {
                        bdcXm.setZl(cqXm.getZl());
                        bdcXm.setSsxz(cqXm.getSsxz());
                        bdcXm.setCqgs(cqXm.getCqgs());
                    }
                    BdcSpxx cqSpxx = bdcSpxxService.getBdcSpxxByProid(cqProid);
                    if (cqSpxx != null && bdcSpxx != null) {
                        bdcSpxx.setZl(cqSpxx.getZl());
                        bdcSpxx.setGzwlx(cqSpxx.getGzwlx());
                        bdcSpxx.setZdzhmj(cqSpxx.getZdzhmj());
                        bdcSpxx.setFcghyt(cqSpxx.getFcghyt());
                        bdcSpxx.setZdzhyt(cqSpxx.getZdzhyt());
                        bdcSpxx.setZdzhqlxz(cqSpxx.getZdzhqlxz());
                        bdcSpxx.setYhspdw(cqSpxx.getYhspdw());
                        bdcSpxx.setYhlx(cqSpxx.getYhlx());
                        bdcSpxx.setYhlxb(cqSpxx.getYhlxb());
                        bdcSpxx.setYt(cqSpxx.getYt());
                        bdcSpxx.setMj(cqSpxx.getMj());
                    }
                }
            }
        }
    }


}
