package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.DjsjMapper;
import cn.gtmap.estateplat.config.core.service.BdcXmRelService;
import cn.gtmap.estateplat.config.core.service.DjsjService;
import cn.gtmap.estateplat.config.model.InitVoFromParm;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class DjsjServiceImpl implements DjsjService {
    @Autowired
    DjsjMapper djsjMapper;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    BdcXmRelService bdcXmRelService;

    @Override
    public List<DjsjBdcdy> getDjsjBdcdyTdList(HashMap hashMap) {
        return djsjMapper.getDjsjBdcdyTdList(hashMap);
    }

    @Override
    public List<DjsjFwYcHs> getDjsjFwYcHsListByBdcdyh(String bdcdyh) {
        List<DjsjFwYcHs> djsjFwYcHsjList = null;
        if (StringUtils.isNotBlank(bdcdyh)) {
            Example example = new Example(DjsjFwYcHs.class);
            example.createCriteria().andEqualTo("bdcdyh", bdcdyh);
            djsjFwYcHsjList = entityMapper.selectByExample(example);
        }
        return djsjFwYcHsjList;
    }

    @Override
    public List<String> getYdjhByDjh(HashMap map) {
        return djsjMapper.getYdjhByDjh(map);
    }

    @Override
    public List<DjsjBdcdy> getDjsjBdcdyTdFwByDjid(String djid) {
        List<DjsjBdcdy> djsjBdcdyList = null;
        if (StringUtils.isNotBlank(djid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("id", djid);
            djsjBdcdyList = djsjMapper.getDjsjBdcdyTdFwList(hashMap);
        }
        return djsjBdcdyList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<DjsjZdxx> getDjsjZdxxForDjh(final String djh) {
        List<DjsjZdxx> djsjZdxxList = null;
        if (StringUtils.isNotBlank(djh)) {
            HashMap hashMap = new HashMap();
            hashMap.put("djh", djh);
            djsjZdxxList = djsjMapper.getDjsjZdxxList(hashMap);
        }
        return djsjZdxxList;
    }

    @Override
    @Transactional(readOnly = true)
    public DjsjLqxx getDjsjLqxx(final String id) {
        return djsjMapper.getDjsjLqxx(id);
    }

    @Override
    public DjsjCbzdDcb getDjsjCbzdDcbByDjid(String djid) {
        DjsjCbzdDcb djsjCbzdDcb = null;
        if (StringUtils.isNotBlank(djid)) {
            djsjCbzdDcb = djsjMapper.getDjsjCbzdDcbByDjid(djid);
        }
        return djsjCbzdDcb;
    }

    @Override
    public List<DjsjNydDcb> getDjsjNydDcbByDjh(String djh) {
        List<DjsjNydDcb> djsjNydDcbList = null;
        if (StringUtils.isNotBlank(djh)) {
            djsjNydDcbList = djsjMapper.getDjsjNydDcbByDjh(djh);
        }
        return djsjNydDcbList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<DjsjQszdDcb> getDjsjQszdDcb(final String djh) {
        return djsjMapper.getDjsjQszdDcb(djh);
    }

    @Override
    @Transactional(readOnly = true)
    public List<DjsjZdxx> getDjsjZdxx(final String id) {
        List<DjsjZdxx> djsjZdxxList = null;
        if (StringUtils.isNotBlank(id)) {
            HashMap hashMap = new HashMap();
            hashMap.put("id", id);
            djsjZdxxList = djsjMapper.getDjsjZdxxList(hashMap);
        }
        return djsjZdxxList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<DjsjZdxx> getDjsjNydxx(final String id) {
        return djsjMapper.getDjsjNydxx(id);
    }

    @Override
    public String getFwlxByProid(final String proid) {
        String fwlx = "";
        List<BdcXmRel> bdcXmRelList = bdcXmRelService.getBdcXmRelByProid(proid);
        if (bdcXmRelList != null && bdcXmRelList.size() > 0 && StringUtils.isNotBlank(bdcXmRelList.get(0).getQjid())) {
            List<DjsjBdcdy> djsjBdcdyList = getDjsjBdcdyTdFwByDjid(bdcXmRelList.get(0).getQjid());
            if (CollectionUtils.isNotEmpty(djsjBdcdyList))
                fwlx = djsjBdcdyList.get(0).getBdcdyfwlx();
        }
        return fwlx;
    }

    @Override
    public InitVoFromParm getDjxx(String djId, String bdcdyh, String bdclx, String bdcdyFwlx) {
        DjsjFwxx djsjFwxx = null;
        DjsjLqxx djsjLqxx = null;
        DjsjZdxx djsjZdxx = null;
        DjsjZhxx djsjZhxx = null;
        DjsjQszdDcb djsjQszdDcb = null;
        DjsjCbzdDcb cbzdDcb = null;
        DjsjCbzdCbf cbzdCbf = null;
        DjsjNydDcb djsjNydDcb = null;
        List<DjsjZdxx> djsjZdxxList = null;
        List<DjsjZhxx> djsjZhxxList = null;
        List<DjsjFwxx> djsjFwxxList = null;
        List<DjsjFwxx> djsjFwQlrList = null;
        List<DjsjQszdDcb> djsjQszdDcbList = null;
        List<DjsjNydDcb> djsjNydDcbList = null;
        InitVoFromParm initVoFromParm = new InitVoFromParm();
        if (StringUtils.isNoneBlank(djId, bdcdyh, bdclx) && StringUtils.length(bdcdyh) > 19) {
            String djh = StringUtils.substring(bdcdyh, 0, 19);
            if (StringUtils.isNoneBlank(djh)) {
                if (StringUtils.indexOf(bdclx, Constants.BDCLX_HY) == -1) {
                    djsjZdxxList = djsjMapper.getDjsjZdxxForDjh(djh);
                }
                if (CollectionUtils.isNotEmpty(djsjZdxxList)) {
                    djsjZdxx = djsjZdxxList.get(0);
                }
                if (StringUtils.equals(bdclx, Constants.BDCLX_TDFW)) {
                    djsjFwxx = getDjsjFwxx(djId, bdcdyFwlx);
                    if (djsjFwxx != null) {
                        if (StringUtils.isNotBlank(djsjFwxx.getBdcdyh())) {
                            djsjFwQlrList = djsjMapper.getDjsjFwQlr(djsjFwxx.getId());
                        }
                    }
                }
                if (StringUtils.equals(bdclx, Constants.BDCLX_TDSL)) {
                    djsjLqxx = djsjMapper.getDjsjLqxx(djId);
                    if (djsjLqxx != null && StringUtils.isNotBlank(djsjLqxx.getDjh())) {
                        djsjNydDcbList = djsjMapper.getDjsjNydDcbByDjh(djsjLqxx.getDjh());
                    }
                    if (CollectionUtils.isNotEmpty(djsjNydDcbList)) {
                        djsjNydDcb = djsjNydDcbList.get(0);
                    }
                }
                if (StringUtils.indexOf(bdclx, Constants.BDCLX_HY) > -1) {
                    djsjZhxxList = djsjMapper.getDjsjZhxxForDjh(djh);
                    if (CollectionUtils.isNotEmpty(djsjZhxxList)) {
                        djsjZhxx = djsjZhxxList.get(0);
                        if (djsjZhxx == null) {
                            if (StringUtils.isNotBlank(djId)) {
                                djsjZhxx = djsjMapper.getDjsjZhxx(djId);
                            }
                        }
                    }
                }
                if (StringUtils.indexOf(bdclx, Constants.BDCLX_TD) > -1) {
                    cbzdDcb = djsjMapper.getDjsjCbzdDcbByDjid(djId);
                    cbzdCbf = djsjMapper.getDjsjCbzdCbf(djId);
                    if (cbzdDcb != null && StringUtils.isNotBlank(cbzdDcb.getDjh())) {
                        djsjNydDcbList = djsjMapper.getDjsjNydDcbByDjh(cbzdDcb.getDjh());
                    }
                    if (cbzdDcb != null && StringUtils.isNotBlank(cbzdDcb.getZddcbIndex())) {
                        cbzdCbf = djsjMapper.getDjsjCbzdCbf(cbzdDcb.getZddcbIndex());
                    }
                    if (CollectionUtils.isNotEmpty(djsjNydDcbList)) {
                        djsjNydDcb = djsjNydDcbList.get(0);
                    }
                    djsjQszdDcbList = djsjMapper.getDjsjQszdDcb(djId);
                    if (CollectionUtils.isNotEmpty(djsjQszdDcbList)) {
                        djsjQszdDcb = djsjQszdDcbList.get(0);
                    }
                }
            }
        }
        initVoFromParm.setDjsjFwxx(djsjFwxx);
        initVoFromParm.setDjsjLqxx(djsjLqxx);
        initVoFromParm.setDjsjZdxx(djsjZdxx);
        initVoFromParm.setDjsjZhxx(djsjZhxx);
        initVoFromParm.setDjsjQszdDcb(djsjQszdDcb);
        initVoFromParm.setCbzdDcb(cbzdDcb);
        initVoFromParm.setCbzdCbf(cbzdCbf);
        initVoFromParm.setDjsjNydDcb(djsjNydDcb);
        initVoFromParm.setDjsjFwQlrList(djsjFwQlrList);
        initVoFromParm.setDjsjQszdDcbList(djsjQszdDcbList);
        initVoFromParm.setDjsjNydDcbList(djsjNydDcbList);
        initVoFromParm.setDjsjZdxxList(djsjZdxxList);
        initVoFromParm.setDjsjZhxxList(djsjZhxxList);
        return initVoFromParm;
    }

    @Override
    public DjsjFwxx getDjsjFwxx(final String djid, final String bdcdyFwlx) {
        DjsjFwxx djsjFwxx = null;
        if (StringUtils.isNotBlank(djid)) {
            if (StringUtils.equalsIgnoreCase(bdcdyFwlx, Constants.DJSJ_FWDZ_DM)) {
                //多幢
                Map<String, Object> map = Maps.newHashMap();
                map.put("fw_xmxx_index", djid);
                List<DjsjFwXmxx> djsjFwXmxxList = djsjMapper.getDjsjFwXmxx(map);
                if (CollectionUtils.isNotEmpty(djsjFwXmxxList)) {
                    djsjFwxx = new DjsjFwxx();
                    DjsjFwXmxx djsjFwXmxx = djsjFwXmxxList.get(0);
                    djsjFwxx.setBdcdyfwlx(bdcdyFwlx);
                    djsjFwxx.setFwlx(djsjFwXmxx.getFwlx());
                    djsjFwxx.setFwxz(djsjFwXmxx.getFwxz());
                    djsjFwxx.setBdcdyh(djsjFwXmxx.getBdcdyh());
                    djsjFwxx.setCqly(djsjFwXmxx.getCqly());
                    djsjFwxx.setFttdmj(djsjFwXmxx.getFttdmj());
                    djsjFwxx.setDytdmj(djsjFwXmxx.getDytdmj());
                    djsjFwxx.setId(djid);
                    djsjFwxx.setGyqk(djsjFwXmxx.getGyqk());
                    djsjFwxx.setZl(djsjFwXmxx.getZl());
                    djsjFwxx.setLszd(djsjFwXmxx.getLszd());
                    djsjFwxx.setJyjg(djsjFwXmxx.getJyjg());
                    Map<String, Object> ljzMap = Maps.newHashMap();
                    ljzMap.put("fw_xmxx_index", djid);
                    List<DjsjFwLjz> fwLjzList = djsjMapper.getDjsjFwLjz(ljzMap);
                    if (fwLjzList != null && fwLjzList.size() > 0) {
                        List<DjsjFwzbxx> fwzbxxList = new ArrayList<DjsjFwzbxx>();
                        double dzwmj = 0;
                        for (DjsjFwLjz djsjFwLjz : fwLjzList) {
                            dzwmj = dzwmj + djsjFwLjz.getScjzmj();
                            DjsjFwzbxx djsjFwzbxx = new DjsjFwzbxx();
                            djsjFwzbxx.setDh(djsjFwLjz.getDh());
                            djsjFwzbxx.setFwjg(djsjFwLjz.getFwjg());
                            djsjFwzbxx.setGhyt(djsjFwLjz.getFwyt());
                            djsjFwzbxx.setJgsj(djsjFwLjz.getJgrq());
                            djsjFwzbxx.setXmmc(djsjFwLjz.getFwmc());
                            djsjFwzbxx.setZcs(djsjFwLjz.getFwcs());
                            djsjFwzbxx.setZts(CommonUtil.formatEmptyValue(djsjFwLjz.getZts()));
                            djsjFwzbxx.setJzmj(djsjFwLjz.getScjzmj());
                            djsjFwxx.setFwyt(djsjFwLjz.getFwyt());
                            Map<String, Object> hsMap = Maps.newHashMap();
                            hsMap.put("fw_dcb_index", djsjFwLjz.getFwDcbIndex());
                            List<DjsjFwHs> djsjFwhsList = djsjMapper.getDjsjFwHs(hsMap);
                            if (djsjFwhsList != null && djsjFwhsList.size() > 0) {
                                djsjFwxx.setFcdah(djsjFwhsList.get(0).getFcdah());
                            }
                            fwzbxxList.add(djsjFwzbxx);
                        }
                        djsjFwxx.setFwzbxxList(fwzbxxList);
                        djsjFwxx.setJzmj(dzwmj);
                    }
                }
            } else if (StringUtils.equalsIgnoreCase(bdcdyFwlx, Constants.DJSJ_FW_DM)) {
                //独幢
                Map<String, Object> ljzMap = Maps.newHashMap();
                ljzMap.put("fw_dcb_index", djid);
                List<DjsjFwLjz> fwLjzList = djsjMapper.getDjsjFwLjz(ljzMap);
                if (CollectionUtils.isNotEmpty(fwLjzList)) {
                    djsjFwxx = new DjsjFwxx();
                    DjsjFwLjz djsjFwLjz = fwLjzList.get(0);
                    djsjFwxx.setBdcdyfwlx(bdcdyFwlx);
                    djsjFwxx.setBdcdyh(djsjFwLjz.getBdcdyh());
                    djsjFwxx.setId(djid);
                    djsjFwxx.setZl(djsjFwLjz.getZldz());
                    djsjFwxx.setLszd(djsjFwLjz.getLszd());
                    DjsjFwzbxx djsjFwzbxx = new DjsjFwzbxx();
                    djsjFwzbxx.setDh(djsjFwLjz.getDh());
                    djsjFwzbxx.setFwjg(djsjFwLjz.getFwjg());
                    djsjFwzbxx.setGhyt(djsjFwLjz.getFwyt());
                    djsjFwzbxx.setJgsj(djsjFwLjz.getJgrq());
                    djsjFwzbxx.setZcs(djsjFwLjz.getFwcs());
                    djsjFwxx.setFwyt(djsjFwLjz.getFwyt());
                    //zwq 独幢的时候无法获取定着物面积
                    djsjFwxx.setJzmj(djsjFwLjz.getScjzmj());
                    djsjFwzbxx.setJzmj(djsjFwLjz.getScjzmj());
                    List<DjsjFwHs> djsjFwhsList = djsjMapper.getDjsjFwHs(ljzMap);
                    if (CollectionUtils.isNotEmpty(djsjFwhsList)) {
                        DjsjFwHs djsjFwHs = djsjFwhsList.get(0);
                        djsjFwxx.setCqly(djsjFwHs.getCqly());
                        djsjFwxx.setGyqk(djsjFwHs.getGyqk());
                        djsjFwxx.setFwxz(djsjFwHs.getFwxz());
                        djsjFwxx.setDycs(djsjFwHs.getDycs());
                        djsjFwxx.setFcdah(djsjFwHs.getFcdah());
                        djsjFwxx.setFwlx(djsjFwHs.getFwlx());
                    }
                    List<DjsjFwHs> djsjFwhsMjList = djsjMapper.getDjsjFwHsSumMj(ljzMap);
                    if (djsjFwhsMjList != null && djsjFwhsMjList.size() > 0) {
                        double dytdmj = 0;
                        double fttdmj = 0;
                        double tnjzmj = 0;
                        for (DjsjFwHs djsjFwHs : djsjFwhsMjList) {
                            dytdmj = dytdmj + djsjFwHs.getDytdmj();
                            fttdmj = fttdmj + djsjFwHs.getFttdmj();
                            tnjzmj = tnjzmj + djsjFwHs.getSctnjzmj();
                            djsjFwxx.setJyjg(djsjFwHs.getJyjg());
                        }
                        djsjFwxx.setDytdmj(dytdmj);
                        djsjFwxx.setFttdmj(fttdmj);
                        djsjFwxx.setTnjzmj(tnjzmj);
                    }
                    List<DjsjFwzbxx> fwzbxxList = Lists.newArrayList();
                    fwzbxxList.add(djsjFwzbxx);
                    djsjFwxx.setFwzbxxList(fwzbxxList);
                }
            } else if (StringUtils.equalsIgnoreCase(bdcdyFwlx, Constants.DJSJ_FWHS_DM)) {
                //戶室
                Map<String, Object> hsMap = Maps.newHashMap();
                hsMap.put("fw_hs_index", djid);
                List<DjsjFwHs> fwHsList = djsjMapper.getDjsjFwHs(hsMap);
                if (CollectionUtils.isEmpty(fwHsList)) {
                    fwHsList = djsjMapper.getDjsjFwYcHs(hsMap);
                }
                if (CollectionUtils.isNotEmpty(fwHsList)) {
                    djsjFwxx = new DjsjFwxx();
                    DjsjFwHs djsjFwHs = fwHsList.get(0);
                    djsjFwxx.setBdcdyfwlx(bdcdyFwlx);
                    djsjFwxx.setFwlx(djsjFwHs.getFwlx());
                    djsjFwxx.setBdcdyh(djsjFwHs.getBdcdyh());
                    djsjFwxx.setId(djid);
                    djsjFwxx.setZl(djsjFwHs.getZl());
                    djsjFwxx.setLszd(djsjFwHs.getLszd());
                    djsjFwxx.setCqly(djsjFwHs.getCqly());
                    djsjFwxx.setGyqk(djsjFwHs.getGyqk());
                    djsjFwxx.setFwxz(djsjFwHs.getFwxz());
                    djsjFwxx.setDycs(djsjFwHs.getDycs());
                    djsjFwxx.setJyjg(djsjFwHs.getJyjg());
                    djsjFwxx.setJzmj(djsjFwHs.getScjzmj());
                    //zwq 从fw_hs获取ycjzmj
                    djsjFwxx.setYcjzmj(djsjFwHs.getYcjzmj());
                    djsjFwxx.setFtjzmj(djsjFwHs.getScftjzmj());
                    djsjFwxx.setDytdmj(djsjFwHs.getDytdmj());
                    djsjFwxx.setFttdmj(djsjFwHs.getFttdmj());
                    djsjFwxx.setFcdah(djsjFwHs.getFcdah());
                    djsjFwxx.setFwyt(djsjFwHs.getGhyt());
                    djsjFwxx.setGhyt(djsjFwHs.getGhyt());
                    djsjFwxx.setTnjzmj(djsjFwHs.getSctnjzmj());
                    djsjFwxx.setCg(djsjFwHs.getCg());
                    //从fw_hs获取tdyt，qsrq，zzrq
                    djsjFwxx.setTdyt(djsjFwHs.getTdyt());
                    djsjFwxx.setQsrq(djsjFwHs.getQsrq());
                    djsjFwxx.setZzrq(djsjFwHs.getZzrq());
                    Map<String, Object> ljzMap = Maps.newHashMap();
                    ljzMap.put("fw_dcb_index", djsjFwHs.getFwDcbIndex());
                    List<DjsjFwLjz> djsjFwLjzList = djsjMapper.getDjsjFwLjz(ljzMap);
                    List<DjsjFwzbxx> fwzbxxList = new ArrayList<DjsjFwzbxx>();
                    if (CollectionUtils.isNotEmpty(djsjFwLjzList)) {
                        DjsjFwLjz djsjFwLjz = djsjFwLjzList.get(0);
                        DjsjFwzbxx djsjFwzbxx = new DjsjFwzbxx();
                        djsjFwzbxx.setFwjg(djsjFwLjz.getFwjg());
                        djsjFwzbxx.setJgsj(djsjFwLjz.getJgrq());
                        djsjFwzbxx.setZcs(djsjFwLjz.getFwcs());
                        djsjFwzbxx.setJzmj(djsjFwHs.getScjzmj());
                        djsjFwzbxx.setGhyt(djsjFwHs.getGhyt());
                        fwzbxxList.add(djsjFwzbxx);
                    }
                    djsjFwxx.setFwzbxxList(fwzbxxList);
                }
            }
        }
        return djsjFwxx;
    }

    @Override
    public List<Map<String, String>> getDjBdcdyListByPage(Map<String, Object> paramMap) {
        return djsjMapper.getDjBdcdyListByPage(paramMap);
    }

    @Override
    public List<DjsjLqxx> getDjsjLqxxByDjh(@Param("djh") String djh) {
        return djsjMapper.getDjsjLqxxByDjh(djh);
    }

    @Override
    public List<DjsjCbzdDcb> getDjsjCbzdDcbByDjh(@Param("djh") String djh) {
        return djsjMapper.getDjsjCbzdDcbByDjh(djh);
    }

    @Override
    public List<DjsjFwHs> getDjsjFwHsByBdcdyh(String bdcdyh) {
        List<DjsjFwHs> djsjFwHsList = null;
        if(StringUtils.isNotBlank(bdcdyh)) {
            Map paramMap = Maps.newHashMap();
            paramMap.put("bdcdyh",bdcdyh);
            djsjFwHsList = djsjMapper.getDjsjFwHs(paramMap);
        }
        return djsjFwHsList;
    }

    @Override
    public List<Map> getDjQlrList(Map map) {
        List<Map> qlrMapList=djsjMapper.getDjQlrList(map);
        return qlrMapList;
    }
    @Override
    public Integer queryBdcdyCountByDjh(final String djh) {
        return djsjMapper.queryBdcdyCountByDjh(djh);
    }

    @Override
    public List<String> getBdcfwlxByBdcdyh(String bdcdyh) {
        return djsjMapper.getBdcfwlxByBdcdyh(bdcdyh);
    }
}
