package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.DwdmMapper;
import cn.gtmap.estateplat.config.core.service.DwdmService;
import cn.gtmap.estateplat.model.server.core.Dwxx;
import com.gtis.plat.service.SysUserService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/26.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class DwdmServiceImpl implements DwdmService {
    @Autowired
    DwdmMapper dwdmMapper;
    @Autowired
    SysUserService sysUserService;

    @Override
    public String getDwdmByUserid(String userid) {
        String userDwdm = sysUserService.getUserRegionCode(userid);
        if (StringUtils.isNotBlank(userDwdm)) {
            while (StringUtils.isNotBlank(userDwdm) && userDwdm.endsWith("0")) {
                userDwdm = userDwdm.substring(0, userDwdm.length() - 1);
            }
        }
        return userDwdm;
    }

    @Override
    public List<Dwxx> getDwxxList(String xzqdm, int level) {
        HashMap hashMap = new HashMap();
        hashMap.put("likeDwdm", xzqdm);
        hashMap.put("xzLevel", level);
        return dwdmMapper.getDwxxListByMap(hashMap);
    }

    @Override
    public List<Dwxx> getDwxxList() {
        return dwdmMapper.getDwxxListByMap(null);
    }

    @Override
    public Dwxx getDwxxByDwdm(String xzqdm) {
        Dwxx dwxx = null;
        if (StringUtils.isNotBlank(xzqdm)) {
            HashMap hashMap = new HashMap();
            hashMap.put("dwdm", xzqdm);
            List<Dwxx> dwxxList = dwdmMapper.getDwxxListByMap(hashMap);
            if (CollectionUtils.isNotEmpty(dwxxList))
                dwxx = dwxxList.get(0);
        }
        return dwxx;
    }

    @Override
    public List<Dwxx> getDwxxToZsbh(String userDwdm, int level) {
        List<Dwxx> dwxxList = getDwxxList(userDwdm, level);
        if (dwxxList == null)
            dwxxList = new ArrayList<Dwxx>();
        return dwxxList;
    }
}
