package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.DwxxMapper;
import cn.gtmap.estateplat.config.core.service.DwxxService;
import cn.gtmap.estateplat.model.server.core.Dwxx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * <p/>
 *
 * @author <a href="mailto:zhangxing@gtmap.cn">zx</a>
 * @version V1.0
 */
@Service
public class DwxxServiceImpl implements DwxxService {
    @Autowired
    private DwxxMapper dwxxMapper;

    @Override
    public List<Dwxx> getDwxxList(final String xzqdm, final int level) {
        HashMap map = new HashMap();
        map.put("dwdm", xzqdm);
        map.put("xzLevel", level);
        List<Dwxx> dwxxList = dwxxMapper.getDwxxList(map);
        return dwxxList;
    }

    @Override
    public Dwxx getDwxxByDwdm(String dwdm) {
        return dwxxMapper.getDwxxByDwdm(dwdm);
    }

}
