package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.GdBdcQlRelService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdBdcQlRel;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdBdcQlRelServiceImpl implements GdBdcQlRelService {
    @Autowired
    EntityMapper entityMapper;

    /**
     * @param qlid
     * @author <a href="mailto:zhangqiang@gtmap.cn">zhangqiang</a>
     * @rerutn List<GdBdcQlRel>
     * @description 获取过渡关系表
     */
    @Override
    public List<GdBdcQlRel> queryGdBdcQlListByQlid(final String qlid) {
        List<GdBdcQlRel> gdBdcQlRelList = null;
        if (StringUtils.isNotEmpty(qlid)) {
            Example gdBdcQlRel = new Example(GdBdcQlRel.class);
            gdBdcQlRel.createCriteria().andEqualTo("qlid", qlid);
            gdBdcQlRelList = entityMapper.selectByExampleNotNull(GdBdcQlRel.class, gdBdcQlRel);
        }
        return gdBdcQlRelList;

    }

    @Override
    public List<GdBdcQlRel> getGdBdcQlRelListByBdcid(String gdid) {
        List<GdBdcQlRel> gdBdcQlRelList = null;
        if (StringUtils.isNotEmpty(gdid)) {
            Example gdBdcQlRel = new Example(GdBdcQlRel.class);
            gdBdcQlRel.createCriteria().andEqualTo("bdcid", gdid);
            gdBdcQlRelList = entityMapper.selectByExampleNotNull(GdBdcQlRel.class, gdBdcQlRel);
        }
        return gdBdcQlRelList;
    }
}
