package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.service.GdBdcSdService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdBdcSd;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdBdcSdServiceImpl implements GdBdcSdService {

    @Autowired
    EntityMapper entityMapper;

    @Override
    public List<GdBdcSd> getGdBdcSdByProidAndSdzt(String proid, int sdzt) {
        List<GdBdcSd> gdBdcSdList = null;
        if (StringUtils.isNotBlank(proid)) {
            Example example = new Example(GdBdcSd.class);
            example.createCriteria().andEqualTo("proid", proid).andEqualTo("sdzt", sdzt);
            gdBdcSdList = entityMapper.selectByExample(example);
        }
        return gdBdcSdList;
    }
}
