package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.GdCfMapper;
import cn.gtmap.estateplat.config.core.service.GdCfService;
import cn.gtmap.estateplat.model.server.core.GdCf;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/28.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdCfServiceImpl implements GdCfService {
    @Autowired
    GdCfMapper gdCfMapper;

    @Override
    public List<GdCf> getGdCfByProid(String proid, String isjf) {
        List<GdCf> gdCfList = null;
        if (StringUtils.isNotBlank(proid) || StringUtils.isNotBlank(isjf)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", proid);
            hashMap.put("isjf", isjf);
            gdCfList = gdCfMapper.getGdCfList(hashMap);
        }
        return gdCfList;
    }

    @Override
    public List<GdCf> getGdCfListByBdcidAndZxzt(String bdcid, String zxzt) {
        List<GdCf> gdCfList = null;
        if (StringUtils.isNotBlank(bdcid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcid", bdcid);
            if (StringUtils.isNotBlank(zxzt))
                hashMap.put("isjf", zxzt);
            gdCfList = gdCfMapper.getGdCfListByGdBdcQlRel(hashMap);
        }
        return gdCfList;
    }

    @Override
    public void updateGdCfRedundantField(GdCf gdCf) {
        if(gdCf != null&&StringUtils.isNotBlank(gdCf.getCfid())) {
            gdCfMapper.updateGdCfRedundantField(gdCf);
        }
    }
}
