package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.GdDyMapper;
import cn.gtmap.estateplat.config.core.service.GdDyService;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.GdDy;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdDyServiceImpl implements GdDyService {
    @Autowired
    GdDyMapper gdDyMapper;
    @Autowired
    EntityMapper entityMapper;

    @Override
    public List<GdDy> getGdDyListByBdcidAndZxzt(String bdcid, String zxzt) {
        List<GdDy> gdDyList = null;
        if (StringUtils.isNotBlank(bdcid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("bdcid", bdcid);
            if (StringUtils.isNotBlank(zxzt))
                hashMap.put("isjy", zxzt);
            gdDyList = gdDyMapper.getGdDyListByGdBdcQlRel(hashMap);
        }
        return gdDyList;
    }

    @Override
    public GdDy getGdDyByQlidAndIsjy(String qlid, String isjy) {
        GdDy gdDy = null;
        if (StringUtils.isNotBlank(qlid)) {
            Example example = new Example(GdDy.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("qlid", qlid);
            if (StringUtils.isNotBlank(isjy))
                criteria.andEqualTo("isjy", isjy);
            List<GdDy> gdDyList = entityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(gdDyList))
                gdDy = gdDyList.get(0);
        }
        return gdDy;
    }

    @Override
    public void updateGdDyRedundantField(GdDy gdDy) {
        if(gdDy != null&&StringUtils.isNotBlank(gdDy.getDyid())) {
            gdDyMapper.updateGdDyRedundantField(gdDy);
        }
    }
}
