package cn.gtmap.estateplat.config.core.service.impl;

import cn.gtmap.estateplat.config.core.mapper.config.ExamineCheckInfoMapper;
import cn.gtmap.estateplat.config.core.mapper.config.GdFwMapper;
import cn.gtmap.estateplat.config.core.service.GdFwService;
import cn.gtmap.estateplat.config.utils.Constants;
import cn.gtmap.estateplat.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.estateplat.core.support.mybatis.mapper.Example;
import cn.gtmap.estateplat.model.server.core.*;
import cn.gtmap.estateplat.utils.CommonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @version 1.0, 2017/6/29.
 * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
 * @description
 */
@Service
public class GdFwServiceImpl implements GdFwService {
    @Autowired
    GdFwMapper gdFwMapper;
    @Autowired
    EntityMapper entityMapper;
    @Autowired
    private ExamineCheckInfoMapper examineCheckInfoMapper;

    @Override
    public List<String> getCqqidByGdProid(String gdproid) {
        List<String> list = null;
        if (StringUtils.isNotBlank(gdproid)) {
            HashMap hashMap = new HashMap();
            hashMap.put("proid", gdproid);
            list = gdFwMapper.getCqqidByGdProid(hashMap);
        }
        return list;
    }


    @Override
    public List<GdFw> getGdFwByGdProid(String gdproid) {
        List<GdFw> gdFwList = null;
        if (StringUtils.isNotBlank(gdproid)) {
            List<String> qlidlist = getGdFwQlidsByProid(gdproid);
            if (CollectionUtils.isNotEmpty(qlidlist)) {
                gdFwList = getGdFwByQlids(qlidlist);
            }
        }
        return gdFwList;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过qlid获取所对应的房屋
     **/
    public List<GdFw> getGdFwByQlids(List<String> qlidList) {
        List<GdFw> gdFwList = null;
        if (CollectionUtils.isNotEmpty(qlidList)) {
            HashMap queryGdFwMap = new HashMap();
            //房屋查询判断是否是多个房屋时 排除车库等gd_fw_exclx表中的数据
            queryGdFwMap.put("isExcfwlx", "true");
            queryGdFwMap.put("qlids", qlidList);
            gdFwList = gdFwMapper.getGdFwList(queryGdFwMap);
        }
        return gdFwList;
    }

    /**
     * @param
     * @return
     * @auto <a href="mailto:zhouwanqing@gtmap.cn">zhouwanqing</a>
     * @description 通过proid获取所有该项目的qlid
     **/
    @Override
    public List<String> getGdFwQlidsByProid(String proid) {
        List<String> qlidList = null;
        if (StringUtils.isNotBlank(proid)) {
            qlidList = new ArrayList<String>();
            HashMap map = new HashMap();
            map.put("bdclx", Constants.BDCLX_TDFW);
            map.put("proid", proid);
            List<Map> gdQlList = gdFwMapper.getGdQlList(map);
            if (gdQlList != null && gdQlList.size() > 0) {
                for (Map gdQlMap : gdQlList) {
                    if (StringUtils.isNotBlank(CommonUtil.formatEmptyValue(gdQlMap.get("QLID")))) {
                        qlidList.add(CommonUtil.formatEmptyValue(gdQlMap.get("QLID")));
                    }
                }
            }
        }
        return qlidList;
    }

    @Override
    public List<GdFwsyq> getGdFwsyqListByGdproid(String gdproid, String iszx) {
        List<GdFwsyq> gdFwsyqList = null;
        if (StringUtils.isNotBlank(gdproid)) {
            Example example = new Example(GdFwsyq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("proid", gdproid);
            if (StringUtils.isNotBlank(iszx)) {
                criteria.andEqualTo("iszx", iszx);
            }
            gdFwsyqList = entityMapper.selectByExample(example);
        }
        return gdFwsyqList;
    }

    @Override
    @Transactional(readOnly = true)
    public List<GdBdcQlRel> getGdBdcQlRelByBdcidOrQlid(String gdBdcid, String qlid) {
        List<GdBdcQlRel> list = null;
        Example bdcQlRelTemp = new Example(GdBdcQlRel.class);
        Example.Criteria criteria = bdcQlRelTemp.createCriteria();
        if (StringUtils.isNotBlank(gdBdcid)) {
            criteria.andEqualTo("bdcid", gdBdcid);
        }
        if (StringUtils.isNotBlank(qlid)) {
            criteria.andEqualTo("qlid", qlid);
        }
        if (CollectionUtils.isNotEmpty(bdcQlRelTemp.getOredCriteria()) && CollectionUtils.isNotEmpty(bdcQlRelTemp.getOredCriteria().get(0).getAllCriteria())) {
            list = entityMapper.selectByExample(GdBdcQlRel.class, bdcQlRelTemp);
        }
        return list;
    }

    @Override
    @Transactional(readOnly = true)
    public GdFwsyq getGdFwsyqByQlid(String qlid) {
        GdFwsyq gdFwsyq = null;
        if (StringUtils.isNotBlank(qlid)) {
            HashMap map = new HashMap();
            map.put("qlid", qlid);
            map.put("iszx", "0");
            List<GdFwsyq> gdFwsyqList = andEqualQueryGdFwsyq(map);
            if (gdFwsyqList != null && gdFwsyqList.size() > 0) {
                gdFwsyq = gdFwsyqList.get(0);
            }
        }
        return gdFwsyq;
    }

    @Override
    public List<GdFwsyq> andEqualQueryGdFwsyq(Map<String, Object> map) {
        List<GdFwsyq> list = null;
        Example qllxTemp = new Example(GdFwsyq.class);
        if (map != null && map.entrySet().size() > 0) {
            Iterator iter = map.entrySet().iterator();
            Example.Criteria criteria = qllxTemp.createCriteria();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry) iter.next();
                Object key = entry.getKey();
                Object val = entry.getValue();
                //zhouwanqing 通过这个判断现势或历史
                if (StringUtils.equals(CommonUtil.formatEmptyValue(key), "iszx")) {
                    if (val != null && NumberUtils.isNumber(CommonUtil.formatEmptyValue(val))) {
                        criteria.andEqualNvlTo("iszx", val, 0);
                    }
                } else if (val != null) {
                    criteria.andEqualTo(key.toString(), val);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(qllxTemp.getOredCriteria()) && CollectionUtils.isNotEmpty(qllxTemp.getOredCriteria().get(0).getAllCriteria())) {
            list = (List<GdFwsyq>) entityMapper.selectByExample(GdFwsyq.class, qllxTemp);
        }
        return list;
    }

    @Override
    public List<GdFwsyq> queryFwsyqByFwid(String fwid) {
        List<GdFwsyq> list = null;
        if (StringUtils.isNotBlank(fwid)) {
            List<GdBdcQlRel> gdBdcQlRelList = getGdBdcQlRelByBdcidOrQlid(fwid, null);
            if (CollectionUtils.isNotEmpty(gdBdcQlRelList)) {
                list = new ArrayList<GdFwsyq>();
                for (GdBdcQlRel gdBdcQlRel : gdBdcQlRelList) {
                    GdFwsyq gdFwsyq = getGdFwsyqByQlid(gdBdcQlRel.getQlid());
                    if (gdFwsyq != null) {
                        list.add(gdFwsyq);
                    }
                }
            }
        }

        return list;
    }

    @Override
    public List<GdFw> getGdFwByQlid(String qlid) {
        return gdFwMapper.getGdFwByQlid(qlid);
    }
    @Override
    public List<GdFw> getGdFwBybdcdyh(final String bdcdyh){
        List<GdFw> gdFwList=new ArrayList<GdFw>();
        HashMap hashMap=new HashMap();
        hashMap.put("bdcdyh",bdcdyh);
        List<Map<String, String>> tempBdcdyhList = examineCheckInfoMapper.queryFwHsInfoByBdcdyh(hashMap);
        if(CollectionUtils.isNotEmpty(tempBdcdyhList)){
            for (Map map:tempBdcdyhList){
                if(map.containsKey("FCDAH")&&map.get("FCDAH")!=null&&StringUtils.isNotBlank(map.get("FCDAH").toString())){
                    List<GdFw> gdFws= gdFwMapper.getGdFwByDah(map.get("FCDAH").toString());
                    if(CollectionUtils.isNotEmpty(gdFws)){
                        gdFwList.addAll(gdFws);
                    }
                }
            }
        }

        return gdFwList;
    }

    @Override
    public List<String> getGdFwsyqQlidListByGdid(String gdid) {
        return gdFwMapper.getCqqidByGdid(gdid);
    }

    @Override
    public GdFw getGdFwByFwid(String fwid) {
        return gdFwMapper.getGdFwByFwid(fwid);
    }

    @Override
    public void updateGdFwsyqRedundantField(GdFwsyq gdFwsyq) {
        if(gdFwsyq != null&&StringUtils.isNotBlank(gdFwsyq.getQlid())) {
            gdFwMapper.updateGdFwsyqRedundantField(gdFwsyq);
        }
    }

    @Override
    public void updateGdFwQlRedundantField(GdFwQl gdFwQl) {
        if(gdFwQl != null&&StringUtils.isNotBlank(gdFwQl.getQlid())) {
            gdFwMapper.updateGdFwQlRedundantField(gdFwQl);
        }
    }

    @Override
    public List<GdFwsyq> getGdFwsyqListByFczh(String fczh) {
        List<GdFwsyq> gdFwsyqList = null;
        if (StringUtils.isNotBlank(fczh)) {
            Example example = new Example(GdFwsyq.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("fczh", fczh);
            gdFwsyqList = entityMapper.selectByExample(example);
        }
        return gdFwsyqList;
    }

    @Override
    public GdFwsyq queryGdFwsyqByQlid(String qlid) {
        GdFwsyq gdFwsyq = null;
        if(StringUtils.isNotBlank(qlid)) {
            gdFwsyq = entityMapper.selectByPrimaryKey(GdFwsyq.class,qlid);
        }
        return gdFwsyq;
    }

}
